/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen.components;

import com.direwolf20.buildinggadgets.client.screen.components.DireButton;
import com.direwolf20.buildinggadgets.client.screen.components.GuiTextFieldBase;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuiIncrementer
extends Widget {
    public static final int WIDTH = 64;
    private int x;
    private int y;
    private int min;
    private int max;
    private int value;
    private IIncrementerChanged onChange;
    private DireButton minusButton;
    private GuiTextFieldBase field;
    private DireButton plusButton;

    public GuiIncrementer(int x, int y, int min, int max, @Nullable IIncrementerChanged onChange) {
        super(x, y, 64, 20, StringTextComponent.field_240750_d_);
        this.x = x;
        this.y = y;
        this.min = min;
        this.max = max;
        this.value = 0;
        this.onChange = onChange;
        this.minusButton = new DireButton(this.x, this.y - 1, 12, 17, (ITextComponent)new StringTextComponent("-"), button -> this.updateValue(true));
        this.field = new GuiTextFieldBase(Minecraft.func_71410_x().field_71466_p, x + 13, y, 40).setDefaultInt(this.value).restrictToNumeric();
        this.plusButton = new DireButton(this.x + 40 + 14, this.y - 1, 12, 17, (ITextComponent)new StringTextComponent("+"), button -> this.updateValue(false));
        this.field.func_146180_a(String.valueOf(this.value));
    }

    public GuiIncrementer(int x, int y) {
        this(x, y, Integer.MIN_VALUE, Integer.MAX_VALUE, null);
    }

    public int getValue() {
        return this.value;
    }

    private void updateValue(boolean isMinus) {
        int modifier = 1;
        if (Screen.func_231173_s_()) {
            modifier *= 10;
        }
        int value = isMinus ? this.value - modifier : this.value + modifier;
        this.setValue(value);
    }

    public void setValue(int value) {
        if (value == this.value) {
            return;
        }
        this.value = MathHelper.func_76125_a((int)value, (int)this.min, (int)this.max);
        this.field.func_146180_a(String.valueOf(this.value));
        if (this.onChange != null) {
            this.onChange.onChange(value);
        }
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float partialTick) {
        this.plusButton.func_230430_a_(matrices, mouseX, mouseY, partialTick);
        this.minusButton.func_230430_a_(matrices, mouseX, mouseY, partialTick);
        this.field.func_230430_a_(matrices, mouseX, mouseY, partialTick);
    }

    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.field.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        this.plusButton.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        this.minusButton.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        return false;
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (!this.field.func_230999_j_()) {
            return false;
        }
        this.field.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        return true;
    }

    public boolean func_231042_a_(char p_charTyped_1_, int p_charTyped_2_) {
        if (!this.field.func_230999_j_()) {
            return false;
        }
        this.field.func_231042_a_(p_charTyped_1_, p_charTyped_2_);
        if (this.field.func_146179_b().length() > 1 && this.field.func_146179_b().charAt(0) == '0') {
            this.field.func_146180_a(String.valueOf(this.field.getInt()));
        }
        if (this.field.getInt() > this.max) {
            this.field.func_146180_a(String.valueOf(this.max));
        }
        return true;
    }

    protected void func_230995_c_(boolean isFocused) {
        this.field.func_231049_c__(isFocused);
        super.func_230995_c_(isFocused);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public static interface IIncrementerChanged {
        public void onChange(int var1);
    }
}

