/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen.components;

import com.direwolf20.buildinggadgets.client.OurSounds;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;

public class GuiIconActionable
extends Button {
    private Predicate<Boolean> action;
    private boolean selected;
    private boolean isSelectable;
    private Color selectedColor = Color.GREEN;
    private Color deselectedColor;
    private Color activeColor = this.deselectedColor = new Color(255, 255, 255);
    private ResourceLocation selectedTexture;
    private ResourceLocation deselectedTexture;

    public GuiIconActionable(int x, int y, String texture, ITextComponent message, boolean isSelectable, Predicate<Boolean> action) {
        super(x, y, 25, 25, message, b -> {});
        this.isSelectable = isSelectable;
        this.action = action;
        this.setSelected(action.test(false));
        String assetLocation = "textures/gui/setting/%s.png";
        this.deselectedTexture = new ResourceLocation("buildinggadgets", String.format(assetLocation, texture));
        this.selectedTexture = !isSelectable ? this.deselectedTexture : new ResourceLocation("buildinggadgets", String.format(assetLocation, texture + "_selected"));
    }

    public GuiIconActionable(int x, int y, String texture, ITextComponent message, Predicate<Boolean> action) {
        this(x, y, texture, message, false, action);
    }

    public void setFaded(boolean faded) {
        this.field_230695_q_ = faded ? 0.6f : 1.0f;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.activeColor = selected ? this.selectedColor : this.deselectedColor;
    }

    public void func_230988_a_(SoundHandler soundHandler) {
        soundHandler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)OurSounds.BEEP.getSound(), (float)(this.selected ? 0.6f : 1.0f)));
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        super.func_230982_a_(mouseX, mouseY);
        this.action.test(true);
        if (!this.isSelectable) {
            return;
        }
        this.setSelected(!this.selected);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float partialTick) {
        if (!this.field_230694_p_) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableTexture();
        RenderSystem.color4f((float)((float)this.activeColor.getRed() / 255.0f), (float)((float)this.activeColor.getGreen() / 255.0f), (float)((float)this.activeColor.getBlue() / 255.0f), (float)0.15f);
        GuiIconActionable.func_238463_a_((MatrixStack)matrices, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)0.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.field_230688_j_, (int)this.field_230689_k_);
        RenderSystem.enableTexture();
        RenderSystem.color4f((float)((float)this.activeColor.getRed() / 255.0f), (float)((float)this.activeColor.getGreen() / 255.0f), (float)((float)this.activeColor.getBlue() / 255.0f), (float)this.field_230695_q_);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.selected ? this.selectedTexture : this.deselectedTexture);
        GuiIconActionable.func_238463_a_((MatrixStack)matrices, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)0.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.field_230688_j_, (int)this.field_230689_k_);
        if (mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_) {
            GuiIconActionable.func_238476_c_((MatrixStack)matrices, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)this.func_230458_i_().getString(), (int)(mouseX > Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2 ? mouseX + 2 : mouseX - Minecraft.func_71410_x().field_71466_p.func_78256_a(this.func_230458_i_().getString())), (int)(mouseY - 10), (int)this.activeColor.getRGB());
        }
    }
}

