/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.config.validator;

import fr.raksrinana.fallingtree.fabric.config.validator.BlockIdRunner;
import fr.raksrinana.fallingtree.fabric.config.validator.ItemIdRunner;
import fr.raksrinana.fallingtree.fabric.config.validator.MaxRunner;
import fr.raksrinana.fallingtree.fabric.config.validator.MinMaxRunner;
import fr.raksrinana.fallingtree.fabric.config.validator.MinRunner;
import fr.raksrinana.fallingtree.fabric.config.validator.ValidatorRunner;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import me.shedaniel.autoconfig.ConfigData;

public class Validators {
    public static final MinRunner MIN_RUNNER = new MinRunner();
    public static final MaxRunner MAX_RUNNER = new MaxRunner();
    public static final MinMaxRunner MIN_MAX_RUNNER = new MinMaxRunner();
    public static final BlockIdRunner BLOCK_ID_RUNNER = new BlockIdRunner();
    public static final ItemIdRunner ITEM_ID_RUNNER = new ItemIdRunner();
    public static final List<ValidatorRunner<?>> RUNNERS = Arrays.asList(MIN_RUNNER, MAX_RUNNER, MIN_MAX_RUNNER, BLOCK_ID_RUNNER, ITEM_ID_RUNNER);

    private Validators() {
    }

    public static <T> void runValidators(Class<T> categoryClass, T category, String categoryName) throws ConfigData.ValidationException {
        try {
            for (Field field : categoryClass.getDeclaredFields()) {
                for (ValidatorRunner<?> validator : RUNNERS) {
                    if (validator.validateIfAnnotated(field, category)) continue;
                    throw new ConfigData.ValidationException("FallingTree config field " + categoryName + "." + field.getName() + " is invalid");
                }
            }
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new ConfigData.ValidationException((Throwable)e);
        }
    }
}

