/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.loot_table.LootTableJson;
import com.ldtteam.datagenerators.loot_table.LootTableTypeEnum;
import com.ldtteam.datagenerators.loot_table.pool.PoolJson;
import com.ldtteam.datagenerators.loot_table.pool.conditions.survives_explosion.SurvivesExplosionConditionJson;
import com.ldtteam.datagenerators.loot_table.pool.entry.EntryJson;
import com.ldtteam.datagenerators.loot_table.pool.entry.EntryTypeEnum;
import com.ldtteam.storageracks.blocks.ModBlocks;
import com.ldtteam.storageracks.blocks.RackBlock;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import org.jetbrains.annotations.NotNull;

public class LootTableProvider
implements IDataProvider {
    private static final String DATAPACK_DIR = "data/storageracks/";
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static final String LOOT_TABLES_DIR = "data/storageracks/loot_tables/blocks";
    private final DataGenerator generator;

    public LootTableProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        for (RackBlock block : ModBlocks.racks) {
            this.saveBlock(block, cache);
        }
        this.saveBlock(ModBlocks.stoneController, cache);
        this.saveBlock(ModBlocks.ironController, cache);
        this.saveBlock(ModBlocks.emeraldController, cache);
        this.saveBlock(ModBlocks.diamondController, cache);
    }

    private void saveBlock(Block block, DirectoryCache cache) throws IOException {
        if (block.getRegistryName() != null) {
            EntryJson entryJson = new EntryJson();
            entryJson.setType(EntryTypeEnum.ITEM);
            entryJson.setName(block.getRegistryName().toString());
            PoolJson poolJson = new PoolJson();
            poolJson.setEntries(Collections.singletonList(entryJson));
            poolJson.setRolls(1);
            poolJson.setConditions(Collections.singletonList(new SurvivesExplosionConditionJson()));
            LootTableJson lootTableJson = new LootTableJson();
            lootTableJson.setType(LootTableTypeEnum.BLOCK);
            lootTableJson.setPools(Collections.singletonList(poolJson));
            Path savePath = this.generator.func_200391_b().resolve(LOOT_TABLES_DIR).resolve(block.getRegistryName().func_110623_a() + ".json");
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)lootTableJson.serialize(), (Path)savePath);
        }
    }

    @NotNull
    public String func_200397_b() {
        return "Default Block Loot Tables Provider";
    }
}

