/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.blocks;

import com.ldtteam.storageracks.ModCreativeTabs;
import com.ldtteam.storageracks.blocks.ControllerBlock;
import com.ldtteam.storageracks.blocks.FrameType;
import com.ldtteam.storageracks.blocks.RackBlock;
import com.ldtteam.storageracks.blocks.RackList;
import com.ldtteam.storageracks.utils.LootTableProvider;
import com.ldtteam.structurize.api.generation.ModBlockStateProvider;
import com.ldtteam.structurize.api.generation.ModItemModelProvider;
import com.ldtteam.structurize.api.generation.ModLanguageProvider;
import com.ldtteam.structurize.api.generation.ModRecipeProvider;
import com.ldtteam.structurize.blocks.types.WoodType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="storageracks", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModBlocks {
    public static List<RackBlock> racks = new ArrayList<RackBlock>();
    public static ControllerBlock stoneController;
    public static ControllerBlock ironController;
    public static ControllerBlock goldController;
    public static ControllerBlock emeraldController;
    public static ControllerBlock diamondController;

    private ModBlocks() {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ModBlocks.init((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ModBlocks.registerBlockItem((IForgeRegistry<Item>)event.getRegistry());
    }

    public static void init(IForgeRegistry<Block> registry) {
        for (WoodType woodType : WoodType.values()) {
            ArrayList<RackBlock> list = new ArrayList<RackBlock>();
            for (FrameType frame : FrameType.values()) {
                list.add(new RackBlock(woodType, frame, frame.getCost()));
            }
            for (int i = 0; i < list.size() - 1; ++i) {
                ((RackBlock)((Object)list.get(i))).setNext((Block)list.get(i + 1));
            }
            racks.addAll(list);
        }
        for (RackBlock rack : racks) {
            registry.register((IForgeRegistryEntry)rack);
        }
        stoneController = new ControllerBlock("stone", Items.field_221698_bk, 1);
        ironController = new ControllerBlock("iron", Items.field_221696_bj, 2);
        goldController = new ControllerBlock("gold", Items.field_221739_dF, 3);
        emeraldController = new ControllerBlock("emerald", Items.field_221732_cb, 4);
        diamondController = new ControllerBlock("diamond", null, 5);
        stoneController.setNext(ironController);
        ironController.setNext(goldController);
        goldController.setNext(emeraldController);
        emeraldController.setNext(diamondController);
        registry.register((IForgeRegistryEntry)stoneController);
        registry.register((IForgeRegistryEntry)ironController);
        registry.register((IForgeRegistryEntry)goldController);
        registry.register((IForgeRegistryEntry)emeraldController);
        registry.register((IForgeRegistryEntry)diamondController);
    }

    public static void registerBlockItem(IForgeRegistry<Item> registry) {
        Item.Properties properties = new Item.Properties().func_200916_a(ModCreativeTabs.STORAGERACKS);
        for (RackBlock rack : racks) {
            registry.register(new BlockItem((Block)rack, properties).setRegistryName(rack.getRegistryName()));
        }
        registry.register(new BlockItem((Block)stoneController, properties).setRegistryName(stoneController.getRegistryName()));
        registry.register(new BlockItem((Block)ironController, properties).setRegistryName(ironController.getRegistryName()));
        registry.register(new BlockItem((Block)goldController, properties).setRegistryName(goldController.getRegistryName()));
        registry.register(new BlockItem((Block)emeraldController, properties).setRegistryName(emeraldController.getRegistryName()));
        registry.register(new BlockItem((Block)diamondController, properties).setRegistryName(diamondController.getRegistryName()));
    }

    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().func_200390_a((IDataProvider)new ModLanguageProvider(event.getGenerator(), "storageracks", "default"));
        event.getGenerator().func_200390_a((IDataProvider)new ModRecipeProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new ModBlockStateProvider(event.getGenerator(), "storageracks", event.getExistingFileHelper()));
        event.getGenerator().func_200390_a((IDataProvider)new ModItemModelProvider(event.getGenerator(), "storageracks", event.getExistingFileHelper()));
        new RackList().provide(event);
        event.getGenerator().func_200390_a((IDataProvider)new LootTableProvider(event.getGenerator()));
    }
}

