/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.world.player_chunk_tick;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.PlayerGenerationTracker;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ChunkManager.class})
public abstract class ThreadedAnvilChunkStorageMixin {
    @Shadow
    @Final
    private Int2ObjectMap<ChunkManager.EntityTracker> field_219272_z;
    @Shadow
    @Final
    private ServerWorld field_219255_i;
    @Shadow
    @Final
    private PlayerGenerationTracker field_219271_y;
    @Shadow
    @Final
    private ChunkManager.ProxyTicketManager field_219267_u;
    @Shadow
    private int field_219247_A;

    @Overwrite
    public void func_219183_a(ServerPlayerEntity player) {
        boolean movedSections;
        for (ChunkManager.EntityTracker tracker : this.field_219272_z.values()) {
            if (tracker.field_219403_c == player) {
                tracker.func_219397_a(this.field_219255_i.func_217369_A());
                continue;
            }
            tracker.func_219400_b(player);
        }
        SectionPos oldPos = player.func_213842_M();
        SectionPos newPos = SectionPos.func_218157_a((Entity)player);
        boolean isWatchingWorld = this.field_219271_y.func_225419_d(player);
        boolean doesNotGenerateChunks = this.func_219187_b(player);
        boolean bl = movedSections = !newPos.equals((Object)oldPos);
        if (movedSections || isWatchingWorld != doesNotGenerateChunks) {
            this.func_223489_c(player);
            if (!isWatchingWorld) {
                this.field_219267_u.func_219367_b(oldPos, player);
            }
            if (!doesNotGenerateChunks) {
                this.field_219267_u.func_219341_a(newPos, player);
            }
            if (!isWatchingWorld && doesNotGenerateChunks) {
                this.field_219271_y.func_219446_a(player);
            }
            if (isWatchingWorld && !doesNotGenerateChunks) {
                this.field_219271_y.func_219447_b(player);
            }
        } else {
            return;
        }
        long oldChunkPos = ChunkPos.func_77272_a((int)oldPos.func_177958_n(), (int)oldPos.func_177952_p());
        long newChunkPos = ChunkPos.func_77272_a((int)newPos.func_177958_n(), (int)newPos.func_177952_p());
        this.field_219271_y.func_219445_a(oldChunkPos, newChunkPos, player);
        if (player.field_70170_p == this.field_219255_i) {
            this.sendChunks(oldPos, player);
        }
    }

    private void sendChunks(SectionPos oldPos, ServerPlayerEntity player) {
        int newCenterX = MathHelper.func_76128_c((double)player.func_226277_ct_()) >> 4;
        int newCenterZ = MathHelper.func_76128_c((double)player.func_226281_cx_()) >> 4;
        int oldCenterX = oldPos.func_218149_a();
        int oldCenterZ = oldPos.func_218148_c();
        int watchRadius = this.field_219247_A;
        int watchDiameter = watchRadius * 2;
        if (Math.abs(oldCenterX - newCenterX) <= watchDiameter && Math.abs(oldCenterZ - newCenterZ) <= watchDiameter) {
            int minX = Math.min(newCenterX, oldCenterX) - watchRadius;
            int minZ = Math.min(newCenterZ, oldCenterZ) - watchRadius;
            int maxX = Math.max(newCenterX, oldCenterX) + watchRadius;
            int maxZ = Math.max(newCenterZ, oldCenterZ) + watchRadius;
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    boolean isWithinNewRadius;
                    boolean isWithinOldRadius = ThreadedAnvilChunkStorageMixin.getChunkDistance(x, z, oldCenterX, oldCenterZ) <= watchRadius;
                    boolean bl = isWithinNewRadius = ThreadedAnvilChunkStorageMixin.getChunkDistance(x, z, newCenterX, newCenterZ) <= watchRadius;
                    if (isWithinNewRadius && !isWithinOldRadius) {
                        this.startWatchingChunk(player, x, z);
                    }
                    if (!isWithinOldRadius || isWithinNewRadius) continue;
                    this.stopWatchingChunk(player, x, z);
                }
            }
        } else {
            int z;
            int x;
            for (x = oldCenterX - watchRadius; x <= oldCenterX + watchRadius; ++x) {
                for (z = oldCenterZ - watchRadius; z <= oldCenterZ + watchRadius; ++z) {
                    this.stopWatchingChunk(player, x, z);
                }
            }
            for (x = newCenterX - watchRadius; x <= newCenterX + watchRadius; ++x) {
                for (z = newCenterZ - watchRadius; z <= newCenterZ + watchRadius; ++z) {
                    this.startWatchingChunk(player, x, z);
                }
            }
        }
    }

    protected void startWatchingChunk(ServerPlayerEntity player, int x, int z) {
        Chunk chunk;
        ChunkHolder holder = this.func_219219_b(ChunkPos.func_77272_a((int)x, (int)z));
        if (holder != null && (chunk = holder.func_219298_c()) != null) {
            this.func_219180_a(player, new IPacket[2], chunk);
        }
    }

    protected void stopWatchingChunk(ServerPlayerEntity player, int x, int z) {
        player.func_213845_a(new ChunkPos(x, z));
    }

    private static int getChunkDistance(int x, int z, int centerX, int centerZ) {
        return Math.max(Math.abs(x - centerX), Math.abs(z - centerZ));
    }

    @Shadow
    protected abstract boolean func_219187_b(ServerPlayerEntity var1);

    @Shadow
    protected abstract SectionPos func_223489_c(ServerPlayerEntity var1);

    @Shadow
    protected abstract ChunkHolder func_219219_b(long var1);

    @Shadow
    protected abstract void func_219180_a(ServerPlayerEntity var1, IPacket<?>[] var2, Chunk var3);
}

