/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.MultipartBakedModel;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MultipartBakedModel.class})
public class MixinMultipartBakedModel {
    private Map<BlockState, List<IBakedModel>> stateCacheFast;
    @Shadow
    @Final
    private List<Pair<Predicate<BlockState>, IBakedModel>> field_188626_f;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(List<Pair<Predicate<BlockState>, IBakedModel>> components, CallbackInfo ci) {
        this.stateCacheFast = new IdentityHashMap<BlockState, List<IBakedModel>>();
    }

    @Overwrite(remap=false)
    public List<BakedQuad> getQuads(BlockState state, Direction face, Random random, IModelData modelData) {
        if (state == null) {
            return Collections.emptyList();
        }
        List<IBakedModel> models = this.stateCacheFast.get(state);
        if (models == null) {
            models = new ArrayList<IBakedModel>(this.field_188626_f.size());
            for (Pair<Predicate<BlockState>, IBakedModel> pair : this.field_188626_f) {
                if (!((Predicate)pair.getLeft()).test(state)) continue;
                models.add((IBakedModel)pair.getRight());
            }
            this.stateCacheFast.put(state, models);
        }
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        long seed = random.nextLong();
        for (IBakedModel model : models) {
            random.setSeed(seed);
            list.addAll(model.getQuads(state, face, random, modelData));
        }
        return list;
    }
}

