/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.entity.fast_render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.ObjectList;
import me.jellysquid.mods.sodium.client.model.ModelCuboidAccessor;
import me.jellysquid.mods.sodium.client.model.consumer.QuadVertexConsumer;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.math.Matrix3fExtended;
import me.jellysquid.mods.sodium.client.util.math.Matrix4fExtended;
import me.jellysquid.mods.sodium.client.util.math.MatrixUtil;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.vector.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ModelRenderer.class})
public class MixinModelPart {
    private static final float NORM = 0.0625f;
    @Shadow
    @Final
    private ObjectList<ModelRenderer.ModelBox> field_78804_l;

    @Overwrite
    private void func_228306_a_(MatrixStack.Entry matrices, IVertexBuilder vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        Matrix3fExtended normalExt = MatrixUtil.getExtendedMatrix(matrices.func_227872_b_());
        Matrix4fExtended modelExt = MatrixUtil.getExtendedMatrix(matrices.func_227870_a_());
        QuadVertexConsumer quadConsumer = (QuadVertexConsumer)vertexConsumer;
        int color = ColorABGR.pack(red, green, blue, alpha);
        for (ModelRenderer.ModelBox cuboid : this.field_78804_l) {
            for (ModelRenderer.TexturedQuad quad : ((ModelCuboidAccessor)cuboid).getQuads()) {
                float normX = normalExt.transformVecX(quad.field_228312_b_);
                float normY = normalExt.transformVecY(quad.field_228312_b_);
                float normZ = normalExt.transformVecZ(quad.field_228312_b_);
                int norm = Norm3b.pack(normX, normY, normZ);
                for (ModelRenderer.PositionTextureVertex vertex : quad.field_78239_a) {
                    Vector3f pos = vertex.field_78243_a;
                    float x1 = pos.func_195899_a() * 0.0625f;
                    float y1 = pos.func_195900_b() * 0.0625f;
                    float z1 = pos.func_195902_c() * 0.0625f;
                    float x2 = modelExt.transformVecX(x1, y1, z1);
                    float y2 = modelExt.transformVecY(x1, y1, z1);
                    float z2 = modelExt.transformVecZ(x1, y1, z1);
                    quadConsumer.vertexQuad(x2, y2, z2, color, vertex.field_78241_b, vertex.field_78242_c, light, overlay, norm);
                }
            }
        }
    }
}

