/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.debug;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.util.MemoryTracker;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import net.minecraft.client.gui.overlay.DebugOverlayGui;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DebugOverlayGui.class})
public abstract class MixinDebugHud {
    @Shadow
    private static long func_175240_a(long bytes) {
        throw new UnsupportedOperationException();
    }

    @Inject(method={"getDebugInfoRight"}, at={@At(value="RETURN")})
    private void appendRightText(CallbackInfoReturnable<List<String>> cir) {
        List strings = (List)cir.getReturnValue();
        for (int i = 0; i < strings.size(); ++i) {
            String str = (String)strings.get(i);
            if (!str.startsWith("Allocated:")) continue;
            strings.add(i + 1, MixinDebugHud.getNativeMemoryString());
            break;
        }
        strings.add("");
        strings.addAll(MixinDebugHud.getChunkRendererDebugStrings());
        if (SodiumClientMod.options().advanced.disableDriverBlacklist) {
            strings.add(TextFormatting.RED + "(!!) Driver blacklist ignored");
        }
    }

    private static List<String> getChunkRendererDebugStrings() {
        ChunkRenderBackend<?> backend = SodiumWorldRenderer.getInstance().getChunkRenderer();
        MemoryTracker memoryTracker = backend.getMemoryTracker();
        ArrayList<String> strings = new ArrayList<String>(4);
        strings.add("Chunk Renderer: " + backend.getRendererName());
        if (memoryTracker != null) {
            int allocated = memoryTracker.getAllocatedMemory();
            int used = memoryTracker.getUsedMemory();
            int ratio = (int)Math.floor((double)used / (double)allocated * 100.0);
            strings.add("VRAM: " + MixinDebugHud.func_175240_a(used) + "/" + MixinDebugHud.func_175240_a(allocated) + "MB (" + ratio + "%)");
        }
        strings.addAll(backend.getDebugStrings());
        return strings;
    }

    private static String getNativeMemoryString() {
        return "Off-Heap: +" + MixinDebugHud.func_175240_a(ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed()) + "MB";
    }
}

