/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.buffer_builder.intrinsics;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.DefaultColorVertexBuilder;
import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.model.consumer.GlyphVertexConsumer;
import me.jellysquid.mods.sodium.client.model.consumer.ParticleVertexConsumer;
import me.jellysquid.mods.sodium.client.model.consumer.QuadVertexConsumer;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.UnsafeUtil;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.color.ColorU8;
import me.jellysquid.mods.sodium.client.util.math.Matrix4fExtended;
import me.jellysquid.mods.sodium.client.util.math.MatrixUtil;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector4f;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import sun.misc.Unsafe;

@Mixin(value={BufferBuilder.class})
public abstract class MixinBufferBuilder
extends DefaultColorVertexBuilder
implements ParticleVertexConsumer,
QuadVertexConsumer,
GlyphVertexConsumer {
    @Shadow
    private VertexFormat field_179011_q;
    @Shadow
    private ByteBuffer field_179001_a;
    @Shadow
    private int field_227824_l_;
    @Shadow
    private int field_178997_d;
    @Shadow
    private boolean field_227827_t_;
    @Shadow
    private boolean field_227826_s_;

    @Shadow
    protected abstract void func_181670_b(int var1);

    @Shadow
    public abstract void func_181675_d();

    @Override
    public void vertexParticle(float x, float y, float z, float u, float v, int color, int light) {
        if (this.field_179011_q != DefaultVertexFormats.field_181704_d) {
            this.vertexParticleFallback(x, y, z, u, v, color, light);
            return;
        }
        int size = this.field_179011_q.func_177338_f();
        this.func_181670_b(size);
        if (UnsafeUtil.isAvailable()) {
            this.vertexParticleUnsafe(x, y, z, u, v, color, light);
        } else {
            this.vertexParticleSafe(x, y, z, u, v, color, light);
        }
        this.field_227824_l_ += size;
        ++this.field_178997_d;
    }

    private void vertexParticleFallback(float x, float y, float z, float u, float v, int color, int light) {
        this.func_225582_a_(x, y, z);
        this.func_225583_a_(u, v);
        this.func_225586_a_(ColorABGR.unpackRed(color), ColorABGR.unpackGreen(color), ColorABGR.unpackBlue(color), ColorABGR.unpackAlpha(color));
        this.func_227886_a_(light);
        this.func_181675_d();
    }

    private void vertexParticleSafe(float x, float y, float z, float u, float v, int color, int light) {
        int i = this.field_227824_l_;
        ByteBuffer buffer = this.field_179001_a;
        buffer.putFloat(i, x);
        buffer.putFloat(i += 4, y);
        buffer.putFloat(i += 4, z);
        buffer.putFloat(i += 4, u);
        buffer.putFloat(i += 4, v);
        buffer.putInt(i += 4, color);
        buffer.putInt(i += 4, light);
        i += 4;
    }

    private void vertexParticleUnsafe(float x, float y, float z, float u, float v, int color, int light) {
        long i = MemoryUtil.memAddress((ByteBuffer)this.field_179001_a, (int)this.field_227824_l_);
        Unsafe unsafe = UnsafeUtil.instance();
        unsafe.putFloat(i, x);
        unsafe.putFloat(i += 4L, y);
        unsafe.putFloat(i += 4L, z);
        unsafe.putFloat(i += 4L, u);
        unsafe.putFloat(i += 4L, v);
        unsafe.putInt(i += 4L, color);
        unsafe.putInt(i += 4L, light);
        i += 4L;
    }

    @Override
    public void vertexQuad(float x, float y, float z, int color, float u, float v, int light, int overlay, int normal) {
        if (this.field_227854_a_) {
            throw new IllegalStateException();
        }
        if (!this.field_227826_s_) {
            this.vertexQuadFallback(x, y, z, color, u, v, overlay, light, normal);
            return;
        }
        int size = this.field_179011_q.func_177338_f();
        this.func_181670_b(size);
        if (UnsafeUtil.isAvailable()) {
            this.vertexQuadUnsafe(x, y, z, color, u, v, overlay, light, normal);
        } else {
            this.vertexQuadSafe(x, y, z, color, u, v, overlay, light, normal);
        }
        this.field_227824_l_ += size;
        ++this.field_178997_d;
    }

    private void vertexQuadFallback(float x, float y, float z, int color, float u, float v, int overlay, int light, int normal) {
        this.func_225582_a_(x, y, z);
        this.func_225586_a_(ColorABGR.unpackRed(color), ColorABGR.unpackGreen(color), ColorABGR.unpackBlue(color), ColorABGR.unpackAlpha(color));
        this.func_225583_a_(u, v);
        if (this.field_227827_t_) {
            this.func_227891_b_(overlay);
        }
        this.func_227886_a_(light);
        this.func_225584_a_(Norm3b.unpackX(normal), Norm3b.unpackY(normal), Norm3b.unpackZ(normal));
        this.func_181675_d();
    }

    private void vertexQuadUnsafe(float x, float y, float z, int color, float u, float v, int overlay, int light, int normal) {
        long i = MemoryUtil.memAddress((ByteBuffer)this.field_179001_a, (int)this.field_227824_l_);
        Unsafe unsafe = UnsafeUtil.instance();
        unsafe.putFloat(i, x);
        unsafe.putFloat(i += 4L, y);
        unsafe.putFloat(i += 4L, z);
        unsafe.putInt(i += 4L, color);
        unsafe.putFloat(i += 4L, u);
        unsafe.putFloat(i += 4L, v);
        i += 4L;
        if (this.field_227827_t_) {
            unsafe.putInt(i, overlay);
            i += 4L;
        }
        unsafe.putInt(i, light);
        unsafe.putInt(i += 4L, normal);
    }

    private void vertexQuadSafe(float x, float y, float z, int color, float u, float v, int overlay, int light, int normal) {
        int i = this.field_227824_l_;
        ByteBuffer buffer = this.field_179001_a;
        buffer.putFloat(i, x);
        buffer.putFloat(i += 4, y);
        buffer.putFloat(i += 4, z);
        buffer.putInt(i += 4, color);
        buffer.putFloat(i += 4, u);
        buffer.putFloat(i += 4, v);
        i += 4;
        if (this.field_227827_t_) {
            buffer.putInt(i, overlay);
            i += 4;
        }
        buffer.putInt(i, light);
        buffer.putInt(i += 4, normal);
    }

    public void func_227890_a_(MatrixStack.Entry matrices, BakedQuad quad, float[] brightnessTable, float r, float g, float b, int[] light, int overlay, boolean colorize) {
        if (!this.field_227826_s_) {
            super.func_227890_a_(matrices, quad, brightnessTable, r, g, b, light, overlay, colorize);
            return;
        }
        if (this.field_227854_a_) {
            throw new IllegalStateException();
        }
        ModelQuadView quadView = (ModelQuadView)quad;
        Matrix4f modelMatrix = matrices.func_227870_a_();
        Matrix3f normalMatrix = matrices.func_227872_b_();
        int norm = MatrixUtil.computeNormal(normalMatrix, quad.func_178210_d());
        for (int i = 0; i < 4; ++i) {
            float fB;
            float fG;
            float fR;
            float x = quadView.getX(i);
            float y = quadView.getY(i);
            float z = quadView.getZ(i);
            float brightness = brightnessTable[i];
            if (colorize) {
                int color = quadView.getColor(i);
                float oR = ColorU8.normalize(ColorABGR.unpackRed(color));
                float oG = ColorU8.normalize(ColorABGR.unpackGreen(color));
                float oB = ColorU8.normalize(ColorABGR.unpackBlue(color));
                fR = oR * brightness * r;
                fG = oG * brightness * g;
                fB = oB * brightness * b;
            } else {
                fR = brightness * r;
                fG = brightness * g;
                fB = brightness * b;
            }
            float u = quadView.getTexU(i);
            float v = quadView.getTexV(i);
            int color = ColorABGR.pack(fR, fG, fB, 1.0f);
            Vector4f pos = new Vector4f(x, y, z, 1.0f);
            pos.func_229372_a_(modelMatrix);
            this.vertexQuad(pos.func_195910_a(), pos.func_195913_b(), pos.func_195914_c(), color, u, v, light[i], overlay, norm);
        }
    }

    @Override
    public void vertexGlyph(Matrix4f matrix, float x, float y, float z, int color, float u, float v, int light) {
        Matrix4fExtended matrixExt = MatrixUtil.getExtendedMatrix(matrix);
        float x2 = matrixExt.transformVecX(x, y, z);
        float y2 = matrixExt.transformVecY(x, y, z);
        float z2 = matrixExt.transformVecZ(x, y, z);
        if (this.field_179011_q != DefaultVertexFormats.field_227852_q_) {
            this.vertexGlyphFallback(x2, y2, z2, color, u, v, light);
            return;
        }
        int size = this.field_179011_q.func_177338_f();
        this.func_181670_b(size);
        if (UnsafeUtil.isAvailable()) {
            this.vertexGlyphUnsafe(x2, y2, z2, color, u, v, light);
        } else {
            this.vertexGlyphSafe(x2, y2, z2, color, u, v, light);
        }
        this.field_227824_l_ += size;
        ++this.field_178997_d;
    }

    private void vertexGlyphFallback(float x, float y, float z, int color, float u, float v, int light) {
        this.func_225582_a_(x, y, z);
        this.func_225586_a_(ColorABGR.unpackRed(color), ColorABGR.unpackGreen(color), ColorABGR.unpackBlue(color), ColorABGR.unpackAlpha(color));
        this.func_225583_a_(u, v);
        this.func_227886_a_(light);
        this.func_181675_d();
    }

    private void vertexGlyphSafe(float x, float y, float z, int color, float u, float v, int light) {
        int i = this.field_227824_l_;
        ByteBuffer buffer = this.field_179001_a;
        buffer.putFloat(i, x);
        buffer.putFloat(i += 4, y);
        buffer.putFloat(i += 4, z);
        buffer.putInt(i += 4, color);
        buffer.putFloat(i += 4, u);
        buffer.putFloat(i += 4, v);
        buffer.putInt(i += 4, light);
        i += 4;
    }

    private void vertexGlyphUnsafe(float x, float y, float z, int color, float u, float v, int light) {
        long i = MemoryUtil.memAddress((ByteBuffer)this.field_179001_a, (int)this.field_227824_l_);
        Unsafe unsafe = UnsafeUtil.instance();
        unsafe.putFloat(i, x);
        unsafe.putFloat(i += 4L, y);
        unsafe.putFloat(i += 4L, z);
        unsafe.putInt(i += 4L, color);
        unsafe.putFloat(i += 4L, u);
        unsafe.putFloat(i += 4L, v);
        unsafe.putInt(i += 4L, light);
        i += 4L;
    }
}

