/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.block;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import me.jellysquid.mods.sodium.client.model.consumer.QuadVertexConsumer;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.sink.FallbackQuadSink;
import me.jellysquid.mods.sodium.client.render.pipeline.BlockRenderer;
import me.jellysquid.mods.sodium.client.render.pipeline.context.GlobalRenderContext;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.client.util.ModelQuadUtil;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.rand.XoRoShiRoRandom;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IModelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockModelRenderer.class})
public class MixinBlockModelRenderer {
    private final XoRoShiRoRandom random = new XoRoShiRoRandom();

    @Inject(method={"renderModel(Lnet/minecraft/world/IBlockDisplayReader;Lnet/minecraft/client/renderer/model/IBakedModel;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lcom/mojang/blaze3d/matrix/MatrixStack;Lcom/mojang/blaze3d/vertex/IVertexBuilder;ZLjava/util/Random;JILnet/minecraftforge/client/model/data/IModelData;)Z"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void preRenderBlockInWorld(IBlockDisplayReader world, IBakedModel model, BlockState state, BlockPos pos, MatrixStack matrixStack, IVertexBuilder consumer, boolean cull, Random rand, long seed, int int_1, IModelData modelData, CallbackInfoReturnable<Boolean> cir) {
        GlobalRenderContext renderer = GlobalRenderContext.getInstance(world);
        BlockRenderer blockRenderer = renderer.getBlockRenderer();
        boolean ret = blockRenderer.renderModel(world, state, pos, model, new FallbackQuadSink(consumer, matrixStack), cull, seed, modelData);
        cir.setReturnValue((Object)ret);
    }

    @Overwrite(remap=false)
    public void renderModel(MatrixStack.Entry entry, IVertexBuilder vertexConsumer, BlockState blockState, IBakedModel bakedModel, float red, float green, float blue, int light, int overlay, IModelData modelData) {
        XoRoShiRoRandom random = this.random;
        QuadVertexConsumer quadConsumer = (QuadVertexConsumer)vertexConsumer;
        red = MathHelper.func_76131_a((float)red, (float)0.0f, (float)1.0f);
        green = MathHelper.func_76131_a((float)green, (float)0.0f, (float)1.0f);
        blue = MathHelper.func_76131_a((float)blue, (float)0.0f, (float)1.0f);
        int defaultColor = ColorABGR.pack(red, green, blue, 1.0f);
        for (Direction direction : DirectionUtil.ALL_DIRECTIONS) {
            List quads = bakedModel.getQuads(blockState, direction, (Random)random.setSeedAndReturn(42L), modelData);
            if (quads.isEmpty()) continue;
            MixinBlockModelRenderer.renderQuad(entry, quadConsumer, defaultColor, quads, light, overlay);
        }
        List quads = bakedModel.getQuads(blockState, null, (Random)random.setSeedAndReturn(42L), modelData);
        if (!quads.isEmpty()) {
            MixinBlockModelRenderer.renderQuad(entry, quadConsumer, defaultColor, quads, light, overlay);
        }
    }

    private static void renderQuad(MatrixStack.Entry entry, QuadVertexConsumer vertices, int defaultColor, List<BakedQuad> list, int light, int overlay) {
        if (list.isEmpty()) {
            return;
        }
        for (BakedQuad bakedQuad : list) {
            int color = bakedQuad.func_178212_b() ? defaultColor : -1;
            ModelQuadView quad = (ModelQuadView)bakedQuad;
            for (int i = 0; i < 4; ++i) {
                vertices.vertexQuad(entry, quad.getX(i), quad.getY(i), quad.getZ(i), color, quad.getTexU(i), quad.getTexV(i), light, overlay, ModelQuadUtil.getFacingNormal(bakedQuad.func_178210_d()));
            }
            SpriteUtil.markSpriteActive(quad.getSprite());
        }
    }
}

