/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.entity.inactive_navigations;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import me.jellysquid.mods.lithium.common.entity.EntityNavigationExtended;
import me.jellysquid.mods.lithium.common.world.ServerWorldExtended;
import net.minecraft.block.BlockState;
import net.minecraft.entity.MobEntity;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.profiler.IProfiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.ISpecialSpawner;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.ISpawnWorldInfo;
import net.minecraft.world.storage.SaveFormat;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerWorld.class})
public abstract class ServerWorldMixin
extends World
implements ServerWorldExtended {
    @Mutable
    @Shadow
    @Final
    private Set<PathNavigator> field_217495_I;
    private ReferenceOpenHashSet<PathNavigator> activeEntityNavigations;
    private boolean isIteratingActiveEntityNavigations;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(MinecraftServer server, Executor workerExecutor, SaveFormat.LevelSave session, IServerWorldInfo properties, RegistryKey<World> registryKey, DimensionType dimensionType, IChunkStatusListener worldGenerationProgressListener, ChunkGenerator chunkGenerator, boolean debugWorld, long l, List<ISpecialSpawner> list, boolean bl, CallbackInfo ci) {
        this.field_217495_I = new ReferenceOpenHashSet(this.field_217495_I);
        this.activeEntityNavigations = new ReferenceOpenHashSet();
    }

    @Redirect(method={"onEntityAdded"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/MobEntity;getNavigator()Lnet/minecraft/pathfinding/PathNavigator;"))
    private PathNavigator startListeningOnEntityLoad(MobEntity mobEntity) {
        PathNavigator navigation = mobEntity.func_70661_as();
        ((EntityNavigationExtended)navigation).setRegisteredToWorld(true);
        if (navigation.func_75505_d() != null) {
            this.activeEntityNavigations.add((Object)navigation);
        }
        return navigation;
    }

    @Redirect(method={"removeEntityComplete"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/MobEntity;getNavigator()Lnet/minecraft/pathfinding/PathNavigator;"))
    private PathNavigator stopListeningOnEntityUnload(MobEntity mobEntity) {
        PathNavigator navigation = mobEntity.func_70661_as();
        ((EntityNavigationExtended)navigation).setRegisteredToWorld(false);
        if (navigation.func_75505_d() != null) {
            this.activeEntityNavigations.remove((Object)navigation);
        }
        return navigation;
    }

    @Redirect(method={"notifyBlockUpdate"}, at=@At(value="INVOKE", target="Ljava/util/Set;iterator()Ljava/util/Iterator;"))
    private Iterator<PathNavigator> getActiveListeners(Set<PathNavigator> set) {
        this.isIteratingActiveEntityNavigations = true;
        return this.activeEntityNavigations.iterator();
    }

    @Inject(method={"notifyBlockUpdate"}, at={@At(value="RETURN")})
    private void onIterationFinished(BlockPos pos, BlockState oldState, BlockState newState, int flags, CallbackInfo ci) {
        this.isIteratingActiveEntityNavigations = false;
    }

    @Override
    public void setNavigationActive(Object entityNavigation) {
        this.avoidConcurrentModification();
        this.activeEntityNavigations.add((Object)((PathNavigator)entityNavigation));
    }

    @Override
    public void setNavigationInactive(Object entityNavigation) {
        this.avoidConcurrentModification();
        this.activeEntityNavigations.remove((Object)((PathNavigator)entityNavigation));
    }

    private void avoidConcurrentModification() {
        if (this.isIteratingActiveEntityNavigations) {
            this.activeEntityNavigations = this.activeEntityNavigations.clone();
            this.isIteratingActiveEntityNavigations = false;
        }
    }

    protected ServerWorldMixin(ISpawnWorldInfo properties, RegistryKey<World> registryRef, DimensionType dimensionType, Supplier<IProfiler> profiler, boolean isClient, boolean debugWorld, long seed) {
        super(properties, registryRef, dimensionType, profiler, isClient, debugWorld, seed);
    }

    public boolean isConsistent() {
        int i = 0;
        for (PathNavigator entityNavigation : this.field_217495_I) {
            if (entityNavigation.func_75505_d() == null == this.activeEntityNavigations.contains((Object)entityNavigation)) {
                return false;
            }
            if (entityNavigation.func_75505_d() == null) continue;
            ++i;
        }
        return this.activeEntityNavigations.size() == i;
    }
}

