/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.entity.data_tracker.use_arrays;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityDataManager.class})
public abstract class DataTrackerMixin {
    private static final int DEFAULT_ENTRY_COUNT = 10;
    private static final int GROW_FACTOR = 8;
    @Mutable
    @Shadow
    @Final
    private Map<Integer, EntityDataManager.DataEntry<?>> field_187234_c;
    @Shadow
    @Final
    private ReadWriteLock field_187235_d;
    private EntityDataManager.DataEntry<?>[] entriesArray = new EntityDataManager.DataEntry[10];

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void reinit(Entity trackedEntity, CallbackInfo ci) {
        this.field_187234_c = new Int2ObjectOpenHashMap(this.field_187234_c);
    }

    @Redirect(method={"setEntry"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"))
    private Object onAddTrackedDataInsertMap(Map<Class<? extends Entity>, Integer> map, Object keyRaw, Object valueRaw) {
        int k = (Integer)keyRaw;
        EntityDataManager.DataEntry v = (EntityDataManager.DataEntry)valueRaw;
        EntityDataManager.DataEntry<?>[] storage = this.entriesArray;
        if (storage.length <= k) {
            int newSize = Math.min(k + 8, 256);
            this.entriesArray = storage = Arrays.copyOf(storage, newSize);
        }
        storage[k] = v;
        return this.field_187234_c.put(k, v);
    }

    @Overwrite
    private <T> EntityDataManager.DataEntry<T> func_187219_c(DataParameter<T> data) {
        this.field_187235_d.readLock().lock();
        try {
            EntityDataManager.DataEntry<?>[] array = this.entriesArray;
            int id = data.func_187155_a();
            if (id < 0 || id >= array.length) {
                EntityDataManager.DataEntry<T> dataEntry = null;
                return dataEntry;
            }
            EntityDataManager.DataEntry<?> dataEntry = array[id];
            return dataEntry;
        }
        catch (Throwable cause) {
            throw DataTrackerMixin.onGetException(cause, data);
        }
        finally {
            this.field_187235_d.readLock().unlock();
        }
    }

    private static <T> ReportedException onGetException(Throwable cause, DataParameter<T> data) {
        CrashReport report = CrashReport.func_85055_a((Throwable)cause, (String)"Getting synced entity data");
        CrashReportCategory section = report.func_85058_a("Synced entity data");
        section.func_71507_a("Data ID", data);
        return new ReportedException(report);
    }
}

