/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.biome;

import it.unimi.dsi.fastutil.longs.Long2ReferenceLinkedOpenHashMap;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.biome.BiomeCache;
import me.jellysquid.mods.sodium.common.util.pool.ObjectPool;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.biome.IBiomeMagnifier;

public class BiomeCacheManager {
    private static final int CACHE_SIZE = 256;
    private static final int ARENA_SIZE = 64;
    private final ObjectPool<BiomeCache> pool;
    private final Long2ReferenceLinkedOpenHashMap<BiomeCache> caches = new Long2ReferenceLinkedOpenHashMap(256, 0.5f);

    public BiomeCacheManager(IBiomeMagnifier type, long seed) {
        this.pool = new ObjectPool<BiomeCache>(64, () -> new BiomeCache(type, seed));
    }

    public void populateArrays(int centerX, int centerY, int centerZ, BiomeCache[] array) {
        int minX = centerX - 1;
        int minZ = centerZ - 1;
        int maxX = centerX + 1;
        int maxZ = centerZ + 1;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                long key = SectionPos.func_218166_b((int)x, (int)centerY, (int)z);
                BiomeCache cache = (BiomeCache)this.caches.getAndMoveToFirst(key);
                if (cache == null) {
                    if (this.caches.size() >= 256) {
                        this.release((BiomeCache)this.caches.removeLast());
                    }
                    cache = this.pool.allocate();
                    this.caches.put(key, (Object)cache);
                }
                this.pool.acquireReference(cache);
                array[WorldSlice.getLocalChunkIndex((int)(x - minX), (int)(z - minZ))] = cache;
            }
        }
    }

    public void dropCachesForChunk(int centerX, int centerZ) {
        for (int x = centerX - 1; x <= centerX; ++x) {
            for (int z = centerZ - 1; z <= centerZ; ++z) {
                for (int y = 0; y <= 16; ++y) {
                    BiomeCache column = (BiomeCache)this.caches.remove(SectionPos.func_218166_b((int)x, (int)y, (int)z));
                    if (column == null) continue;
                    this.release(column);
                }
            }
        }
    }

    public void release(BiomeCache cache) {
        this.pool.release(cache);
    }
}

