/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuilder;
import me.jellysquid.mods.sodium.client.world.biome.BiomeCache;
import me.jellysquid.mods.sodium.client.world.biome.BiomeCacheManager;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorCache;
import me.jellysquid.mods.sodium.common.util.pool.ReusableObject;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.lighting.IWorldLightListener;
import net.minecraft.world.lighting.WorldLightManager;

public class WorldSlice
extends ReusableObject
implements IBlockDisplayReader,
BiomeManager.IBiomeReader {
    public static final int NEIGHBOR_BLOCK_RADIUS = 1;
    public static final int NEIGHBOR_CHUNK_RADIUS = MathHelper.func_154354_b((int)1, (int)16) >> 4;
    public static final int SECTION_LENGTH = 1 + NEIGHBOR_CHUNK_RADIUS * 2;
    public static final int BLOCK_LENGTH = 18;
    public static final int BLOCK_COUNT = 5832;
    public static final int SECTION_COUNT = SECTION_LENGTH * SECTION_LENGTH * SECTION_LENGTH;
    public static final int CHUNK_COUNT = SECTION_LENGTH * SECTION_LENGTH;
    private static final ChunkSection EMPTY_SECTION = new ChunkSection(0);
    private final BlockState[] blockStates;
    private final NibbleArray[] blockLightArrays;
    private final NibbleArray[] skyLightArrays;
    private final BiomeCache[] biomeCaches;
    private final BiomeContainer[] biomeArrays;
    private final Map<ColorResolver, BiomeColorCache> colorResolvers = new Reference2ObjectOpenHashMap();
    private ColorResolver prevColorResolver;
    private BiomeColorCache prevColorCache;
    private World world;
    private Chunk[] chunks;
    private BiomeCacheManager biomeCacheManager;
    private int chunkOffsetX;
    private int chunkOffsetY;
    private int chunkOffsetZ;
    private int blockOffsetX;
    private int blockOffsetY;
    private int blockOffsetZ;

    public static Chunk[] createChunkSlice(World world, SectionPos pos) {
        Chunk chunk = world.func_212866_a_(pos.func_177958_n(), pos.func_177952_p());
        ChunkSection section = chunk.func_76587_i()[pos.func_177956_o()];
        if (section == null || section.func_76663_a()) {
            return null;
        }
        int minChunkX = pos.func_177958_n() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkZ = pos.func_177952_p() - NEIGHBOR_CHUNK_RADIUS;
        int maxChunkX = pos.func_177958_n() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkZ = pos.func_177952_p() + NEIGHBOR_CHUNK_RADIUS;
        Chunk[] chunks = new Chunk[SECTION_LENGTH * SECTION_LENGTH];
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                chunks[WorldSlice.getLocalChunkIndex((int)(x - minChunkX), (int)(z - minChunkZ))] = world.func_212866_a_(x, z);
            }
        }
        return chunks;
    }

    public WorldSlice() {
        this.blockStates = new BlockState[5832];
        this.blockLightArrays = new NibbleArray[SECTION_COUNT];
        this.skyLightArrays = new NibbleArray[SECTION_COUNT];
        this.biomeCaches = new BiomeCache[CHUNK_COUNT];
        this.biomeArrays = new BiomeContainer[CHUNK_COUNT];
    }

    public void init(ChunkBuilder<?> builder, World world, SectionPos chunkPos, Chunk[] chunks) {
        int minX = chunkPos.func_218161_d() - 1;
        int minY = chunkPos.func_218151_e() - 1;
        int minZ = chunkPos.func_218164_f() - 1;
        int maxX = chunkPos.func_218152_g() + 1 + 1;
        int maxY = chunkPos.func_218165_h() + 1 + 1;
        int maxZ = chunkPos.func_218143_r() + 1 + 1;
        int minChunkX = minX >> 4;
        int maxChunkX = maxX >> 4;
        int minChunkY = minY >> 4;
        int maxChunkY = maxY >> 4;
        int minChunkZ = minZ >> 4;
        int maxChunkZ = maxZ >> 4;
        this.world = world;
        this.chunks = chunks;
        this.blockOffsetX = minX;
        this.blockOffsetY = minY;
        this.blockOffsetZ = minZ;
        this.chunkOffsetX = chunkPos.func_177958_n() - NEIGHBOR_CHUNK_RADIUS;
        this.chunkOffsetY = chunkPos.func_177956_o() - NEIGHBOR_CHUNK_RADIUS;
        this.chunkOffsetZ = chunkPos.func_177952_p() - NEIGHBOR_CHUNK_RADIUS;
        IWorldLightListener blockLightProvider = this.world.func_225524_e_().func_215569_a(LightType.BLOCK);
        IWorldLightListener skyLightProvider = this.world.func_225524_e_().func_215569_a(LightType.SKY);
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                int chunkXLocal = chunkX - this.chunkOffsetX;
                int chunkZLocal = chunkZ - this.chunkOffsetZ;
                int chunkIdx = WorldSlice.getLocalChunkIndex(chunkXLocal, chunkZLocal);
                Chunk chunk = chunks[chunkIdx];
                this.biomeArrays[chunkIdx] = chunk.func_225549_i_();
                int minBlockX = Math.max(minX, chunkX << 4);
                int maxBlockX = Math.min(maxX, chunkX + 1 << 4);
                int minBlockZ = Math.max(minZ, chunkZ << 4);
                int maxBlockZ = Math.min(maxZ, chunkZ + 1 << 4);
                for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
                    int chunkYLocal = chunkY - this.chunkOffsetY;
                    SectionPos sectionPos = SectionPos.func_218154_a((int)chunkX, (int)chunkY, (int)chunkZ);
                    int sectionIdx = WorldSlice.getLocalSectionIndex(chunkXLocal, chunkYLocal, chunkZLocal);
                    this.blockLightArrays[sectionIdx] = blockLightProvider.func_215612_a(sectionPos);
                    this.skyLightArrays[sectionIdx] = skyLightProvider.func_215612_a(sectionPos);
                    ChunkSection section = null;
                    if (chunkY >= 0 && chunkY < 16) {
                        section = chunk.func_76587_i()[chunkY];
                    }
                    if (section == null) {
                        section = EMPTY_SECTION;
                    }
                    int minBlockY = Math.max(minY, chunkY << 4);
                    int maxBlockY = Math.min(maxY, chunkY + 1 << 4);
                    for (int y = minBlockY; y < maxBlockY; ++y) {
                        for (int z = minBlockZ; z < maxBlockZ; ++z) {
                            for (int x = minBlockX; x < maxBlockX; ++x) {
                                this.blockStates[this.getBlockIndex((int)x, (int)y, (int)z)] = section.func_177485_a(x & 0xF, y & 0xF, z & 0xF);
                            }
                        }
                    }
                }
            }
        }
        this.biomeCacheManager = builder.getBiomeCacheManager();
        this.biomeCacheManager.populateArrays(chunkPos.func_177958_n(), chunkPos.func_177956_o(), chunkPos.func_177952_p(), this.biomeCaches);
    }

    public BlockState func_180495_p(BlockPos pos) {
        return this.blockStates[this.getBlockIndex(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())];
    }

    public BlockState getBlockState(int x, int y, int z) {
        return this.blockStates[this.getBlockIndex(x, y, z)];
    }

    public FluidState func_204610_c(BlockPos pos) {
        return this.func_180495_p(pos).func_204520_s();
    }

    public FluidState getFluidState(int x, int y, int z) {
        return this.getBlockState(x, y, z).func_204520_s();
    }

    public float func_230487_a_(Direction direction, boolean shaded) {
        return this.world.func_230487_a_(direction, shaded);
    }

    public WorldLightManager func_225524_e_() {
        return this.world.func_225524_e_();
    }

    public TileEntity func_175625_s(BlockPos pos) {
        return this.getBlockEntity(pos, Chunk.CreateEntityType.IMMEDIATE);
    }

    public TileEntity getBlockEntity(BlockPos pos, Chunk.CreateEntityType type) {
        return this.chunks[this.getChunkIndexForBlock(pos)].func_177424_a(pos, type);
    }

    public int func_225525_a_(BlockPos pos, ColorResolver resolver) {
        BiomeColorCache cache;
        if (this.prevColorResolver == resolver) {
            cache = this.prevColorCache;
        } else {
            cache = this.colorResolvers.get(resolver);
            if (cache == null) {
                cache = new BiomeColorCache(resolver, this);
                this.colorResolvers.put(resolver, cache);
            }
            this.prevColorResolver = resolver;
            this.prevColorCache = cache;
        }
        return cache.getBlendedColor(pos);
    }

    public int func_226658_a_(LightType type, BlockPos pos) {
        switch (type) {
            case SKY: {
                return this.getLightLevel(this.skyLightArrays, pos);
            }
            case BLOCK: {
                return this.getLightLevel(this.blockLightArrays, pos);
            }
        }
        return 0;
    }

    public int func_226659_b_(BlockPos pos, int ambientDarkness) {
        return 0;
    }

    public boolean func_226660_f_(BlockPos pos) {
        return false;
    }

    private int getLightLevel(NibbleArray[] arrays, BlockPos pos) {
        int z;
        int y;
        int x = pos.func_177958_n();
        NibbleArray array = arrays[this.getSectionIndexForBlock(x, y = pos.func_177956_o(), z = pos.func_177952_p())];
        if (array != null) {
            return array.func_76582_a(x & 0xF, y & 0xF, z & 0xF);
        }
        return 0;
    }

    public Biome func_225526_b_(int x, int y, int z) {
        BiomeContainer array = this.biomeArrays[this.getBiomeIndexForBlock(x, z)];
        if (array != null) {
            return array.func_225526_b_(x, y, z);
        }
        return this.world.func_225604_a_(x, y, z);
    }

    public Biome getCachedBiome(int x, int z) {
        return this.biomeCaches[this.getChunkIndexForBlock(x, z)].getBiome(this, x, z);
    }

    private int getBlockIndex(int x, int y, int z) {
        int x2 = x - this.blockOffsetX;
        int y2 = y - this.blockOffsetY;
        int z2 = z - this.blockOffsetZ;
        return y2 * 18 * 18 + z2 * 18 + x2;
    }

    private int getChunkIndexForBlock(BlockPos pos) {
        return this.getChunkIndexForBlock(pos.func_177958_n(), pos.func_177952_p());
    }

    private int getChunkIndexForBlock(int x, int z) {
        int x2 = (x >> 4) - this.chunkOffsetX;
        int z2 = (z >> 4) - this.chunkOffsetZ;
        return WorldSlice.getLocalChunkIndex(x2, z2);
    }

    private int getBiomeIndexForBlock(int x, int z) {
        int x2 = (x >> 2) - this.chunkOffsetX;
        int z2 = (z >> 2) - this.chunkOffsetZ;
        return WorldSlice.getLocalChunkIndex(x2, z2);
    }

    private int getSectionIndexForBlock(int x, int y, int z) {
        int x2 = (x >> 4) - this.chunkOffsetX;
        int y2 = (y >> 4) - this.chunkOffsetY;
        int z2 = (z >> 4) - this.chunkOffsetZ;
        return WorldSlice.getLocalSectionIndex(x2, y2, z2);
    }

    public static int getLocalChunkIndex(int x, int z) {
        return z * SECTION_LENGTH + x;
    }

    public static int getLocalSectionIndex(int x, int y, int z) {
        return y * SECTION_LENGTH * SECTION_LENGTH + z * SECTION_LENGTH + x;
    }

    @Override
    public void reset() {
        for (BiomeCache cache : this.biomeCaches) {
            this.biomeCacheManager.release(cache);
        }
        Arrays.fill(this.biomeCaches, null);
        Arrays.fill(this.biomeArrays, null);
        Arrays.fill(this.blockLightArrays, null);
        Arrays.fill(this.skyLightArrays, null);
        this.biomeCacheManager = null;
        this.chunks = null;
        this.world = null;
        this.colorResolvers.clear();
        this.prevColorCache = null;
        this.prevColorResolver = null;
    }

    public int getBlockOffsetX() {
        return this.blockOffsetX;
    }

    public int getBlockOffsetY() {
        return this.blockOffsetY;
    }

    public int getBlockOffsetZ() {
        return this.blockOffsetZ;
    }
}

