/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.concurrent.locks.StampedLock;
import me.jellysquid.mods.sodium.client.util.collections.FixedLongHashTable;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListener;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListenerManager;
import net.minecraft.client.multiplayer.ClientChunkProvider;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.lighting.WorldLightManager;

public class SodiumChunkManager
extends ClientChunkProvider
implements ChunkStatusListenerManager {
    private final ClientWorld world;
    private final Chunk emptyChunk;
    private final StampedLock lock = new StampedLock();
    private FixedLongHashTable<Chunk> chunks;
    private ChunkStatusListener listener;
    private int centerX;
    private int centerZ;
    private int radius;

    public SodiumChunkManager(ClientWorld world, int loadDistance) {
        super(world, loadDistance);
        this.world = world;
        this.emptyChunk = new EmptyChunk((World)world, new ChunkPos(0, 0));
        this.radius = SodiumChunkManager.getChunkMapRadius(loadDistance);
        this.chunks = new FixedLongHashTable(SodiumChunkManager.getChunkMapSize(this.radius), 0.5f);
    }

    public void func_73234_b(int x, int z) {
        if (this.chunks.remove(SodiumChunkManager.createChunkKey(x, z)) != null) {
            this.onChunkUnloaded(x, z);
        }
    }

    public Chunk func_212849_a_(int x, int z, ChunkStatus status, boolean create) {
        Chunk chunk = this.getChunkSafe(SodiumChunkManager.createChunkKey(x, z));
        if (chunk == null) {
            return create ? this.emptyChunk : null;
        }
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Chunk getChunkSafe(long key) {
        long stamp = this.lock.tryOptimisticRead();
        Chunk chunk = this.chunks.get(key);
        if (!this.lock.validate(stamp)) {
            stamp = this.lock.readLock();
            try {
                chunk = this.chunks.get(key);
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk func_228313_a_(int x, int z, BiomeContainer biomes, PacketBuffer buf, CompoundNBT tag, int verticalStripBitmask, boolean complete) {
        long key = SodiumChunkManager.createChunkKey(x, z);
        Chunk chunk = this.chunks.get(key);
        if (!complete && chunk != null) {
            chunk.func_227073_a_(biomes, buf, tag, verticalStripBitmask);
        } else {
            if (biomes == null) {
                return null;
            }
            chunk = new Chunk((World)this.world, new ChunkPos(x, z), biomes);
            chunk.func_227073_a_(biomes, buf, tag, verticalStripBitmask);
            long stamp = this.lock.writeLock();
            try {
                this.chunks.put(key, chunk);
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
        }
        this.onChunkLoaded(x, z, chunk);
        return chunk;
    }

    public void func_217251_d(int x, int z) {
        this.centerX = x;
        this.centerZ = z;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_217248_a(int loadDistance) {
        this.radius = SodiumChunkManager.getChunkMapRadius(loadDistance);
        FixedLongHashTable<Object> copy = new FixedLongHashTable<Object>(SodiumChunkManager.getChunkMapSize(this.radius), 0.5f);
        long stamp = this.lock.writeLock();
        try {
            ObjectIterator<Long2ObjectMap.Entry<Chunk>> it = this.chunks.iterator();
            while (it.hasNext()) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
                long pos = entry.getLongKey();
                int x = ChunkPos.func_212578_a((long)pos);
                int z = ChunkPos.func_212579_b((long)pos);
                if (Math.abs(x - this.centerX) > this.radius || Math.abs(z - this.centerZ) > this.radius) continue;
                copy.put(pos, entry.getValue());
            }
            this.chunks = copy;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    public String func_73148_d() {
        return "SodiumChunkCache: " + this.func_217252_g();
    }

    public int func_217252_g() {
        return this.chunks.size();
    }

    @Override
    public void setListener(ChunkStatusListener listener) {
        this.listener = listener;
    }

    private void onChunkLoaded(int x, int z, Chunk chunk) {
        WorldLightManager lightEngine = this.func_212863_j_();
        lightEngine.func_215571_a(new ChunkPos(x, z), true);
        ChunkSection[] sections = chunk.func_76587_i();
        for (int y = 0; y < sections.length; ++y) {
            lightEngine.func_215566_a(SectionPos.func_218154_a((int)x, (int)y, (int)z), ChunkSection.func_222628_a((ChunkSection)sections[y]));
        }
        this.world.func_228323_e_(x, z);
        if (this.listener != null) {
            this.listener.onChunkAdded(x, z);
        }
    }

    private void onChunkUnloaded(int x, int z) {
        if (this.listener != null) {
            this.listener.onChunkRemoved(x, z);
        }
    }

    private static long createChunkKey(int x, int z) {
        return ChunkPos.func_77272_a((int)x, (int)z);
    }

    private static int getChunkMapRadius(int radius) {
        return Math.max(2, radius) + 3;
    }

    private static int getChunkMapSize(int radius) {
        int n = radius * 2 + 1;
        return n * n;
    }
}

