/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.pipeline;

import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuad;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadViewMutable;
import me.jellysquid.mods.sodium.client.model.quad.blender.BiomeColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.sink.ModelQuadSinkDelegate;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.StainedGlassBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.ForgeHooksClient;

public class FluidRenderer {
    private static final IBlockColor FLUID_COLOR_PROVIDER = (state, world, pos, tintIndex) -> {
        if (world == null) {
            return -1;
        }
        return state.func_204520_s().func_206886_c().getAttributes().getColor(world, pos);
    };
    private final BlockPos.Mutable scratchPos = new BlockPos.Mutable();
    private final ModelQuadViewMutable quad = new ModelQuad();
    private final LightPipelineProvider lighters;
    private final BiomeColorBlender biomeColorBlender;
    private final QuadLightData quadLightData = new QuadLightData();
    private final int[] quadColors = new int[4];

    public FluidRenderer(Minecraft client, LightPipelineProvider lighters, BiomeColorBlender biomeColorBlender) {
        int normal = Norm3b.pack(0.0f, 1.0f, 0.0f);
        for (int i = 0; i < 4; ++i) {
            this.quad.setNormal(i, normal);
        }
        this.lighters = lighters;
        this.biomeColorBlender = biomeColorBlender;
    }

    private boolean isFluidExposed(IBlockDisplayReader world, int x, int y, int z, Fluid fluid) {
        BlockPos.Mutable pos = this.scratchPos.func_181079_c(x, y, z);
        return !world.func_204610_c((BlockPos)pos).func_206886_c().func_207187_a(fluid);
    }

    private boolean isSideExposed(IBlockDisplayReader world, int x, int y, int z, Direction dir, float height) {
        BlockPos.Mutable pos = this.scratchPos.func_181079_c(x + dir.func_82601_c(), y + dir.func_96559_d(), z + dir.func_82599_e());
        BlockState blockState = world.func_180495_p((BlockPos)pos);
        if (blockState.func_200132_m()) {
            VoxelShape shape = blockState.func_235754_c_((IBlockReader)world, (BlockPos)pos);
            if (shape == VoxelShapes.func_197868_b()) {
                return dir == Direction.UP;
            }
            if (shape.func_197766_b()) {
                return true;
            }
            VoxelShape threshold = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)height, (double)1.0);
            return !VoxelShapes.func_197875_a((VoxelShape)threshold, (VoxelShape)shape, (Direction)dir);
        }
        return true;
    }

    public boolean render(IBlockDisplayReader world, FluidState fluidState, BlockPos pos, ModelQuadSinkDelegate consumer) {
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        Fluid fluid = fluidState.func_206886_c();
        boolean sfUp = this.isFluidExposed(world, posX, posY + 1, posZ, fluid);
        boolean sfDown = this.isFluidExposed(world, posX, posY - 1, posZ, fluid) && this.isSideExposed(world, posX, posY, posZ, Direction.DOWN, 0.8888889f);
        boolean sfNorth = this.isFluidExposed(world, posX, posY, posZ - 1, fluid);
        boolean sfSouth = this.isFluidExposed(world, posX, posY, posZ + 1, fluid);
        boolean sfWest = this.isFluidExposed(world, posX - 1, posY, posZ, fluid);
        boolean sfEast = this.isFluidExposed(world, posX + 1, posY, posZ, fluid);
        if (!(sfUp || sfDown || sfEast || sfWest || sfNorth || sfSouth)) {
            return false;
        }
        boolean colored = fluidState.func_206886_c().getAttributes().getColor() != -1;
        TextureAtlasSprite[] sprites = ForgeHooksClient.getFluidSprites((IBlockDisplayReader)world, (BlockPos)pos, (FluidState)fluidState);
        boolean rendered = false;
        float h1 = this.getCornerHeight(world, posX, posY, posZ, fluidState.func_206886_c());
        float h2 = this.getCornerHeight(world, posX, posY, posZ + 1, fluidState.func_206886_c());
        float h3 = this.getCornerHeight(world, posX + 1, posY, posZ + 1, fluidState.func_206886_c());
        float h4 = this.getCornerHeight(world, posX + 1, posY, posZ, fluidState.func_206886_c());
        float yOffset = sfDown ? 0.001f : 0.0f;
        ModelQuadViewMutable quad = this.quad;
        QuadLightData light = this.quadLightData;
        LightMode lightMode = !colored && Minecraft.func_71379_u() ? LightMode.SMOOTH : LightMode.FLAT;
        LightPipeline lighter = this.lighters.getLighter(lightMode);
        quad.setFlags(0);
        if (sfUp && this.isSideExposed(world, posX, posY, posZ, Direction.UP, Math.min(Math.min(h1, h2), Math.min(h3, h4)))) {
            float v4;
            float u4;
            float v3;
            float u3;
            float v2;
            float u2;
            float v1;
            float u1;
            TextureAtlasSprite TextureAtlasSprite2;
            h1 -= 0.001f;
            h2 -= 0.001f;
            h3 -= 0.001f;
            h4 -= 0.001f;
            Vector3d velocity = fluidState.func_215673_c((IBlockReader)world, pos);
            if (velocity.field_72450_a == 0.0 && velocity.field_72449_c == 0.0) {
                TextureAtlasSprite2 = sprites[0];
                u1 = TextureAtlasSprite2.func_94214_a(0.0);
                v1 = TextureAtlasSprite2.func_94207_b(0.0);
                u2 = u1;
                v2 = TextureAtlasSprite2.func_94207_b(16.0);
                u3 = TextureAtlasSprite2.func_94214_a(16.0);
                v3 = v2;
                u4 = u3;
                v4 = v1;
            } else {
                TextureAtlasSprite2 = sprites[1];
                float dir = (float)MathHelper.func_181159_b((double)velocity.field_72449_c, (double)velocity.field_72450_a) - 1.5707964f;
                float sin = MathHelper.func_76126_a((float)dir) * 0.25f;
                float cos = MathHelper.func_76134_b((float)dir) * 0.25f;
                u1 = TextureAtlasSprite2.func_94214_a((double)(8.0f + (-cos - sin) * 16.0f));
                v1 = TextureAtlasSprite2.func_94207_b((double)(8.0f + (-cos + sin) * 16.0f));
                u2 = TextureAtlasSprite2.func_94214_a((double)(8.0f + (-cos + sin) * 16.0f));
                v2 = TextureAtlasSprite2.func_94207_b((double)(8.0f + (cos + sin) * 16.0f));
                u3 = TextureAtlasSprite2.func_94214_a((double)(8.0f + (cos + sin) * 16.0f));
                v3 = TextureAtlasSprite2.func_94207_b((double)(8.0f + (cos - sin) * 16.0f));
                u4 = TextureAtlasSprite2.func_94214_a((double)(8.0f + (cos - sin) * 16.0f));
                v4 = TextureAtlasSprite2.func_94207_b((double)(8.0f + (-cos - sin) * 16.0f));
            }
            float uAvg = (u1 + u2 + u3 + u4) / 4.0f;
            float vAvg = (v1 + v2 + v3 + v4) / 4.0f;
            float s1 = (float)sprites[0].func_94211_a() / (sprites[0].func_94212_f() - sprites[0].func_94209_e());
            float s2 = (float)sprites[0].func_94216_b() / (sprites[0].func_94210_h() - sprites[0].func_94206_g());
            float s3 = 4.0f / Math.max(s2, s1);
            u1 = MathHelper.func_219799_g((float)s3, (float)u1, (float)uAvg);
            u2 = MathHelper.func_219799_g((float)s3, (float)u2, (float)uAvg);
            u3 = MathHelper.func_219799_g((float)s3, (float)u3, (float)uAvg);
            u4 = MathHelper.func_219799_g((float)s3, (float)u4, (float)uAvg);
            v1 = MathHelper.func_219799_g((float)s3, (float)v1, (float)vAvg);
            v2 = MathHelper.func_219799_g((float)s3, (float)v2, (float)vAvg);
            v3 = MathHelper.func_219799_g((float)s3, (float)v3, (float)vAvg);
            v4 = MathHelper.func_219799_g((float)s3, (float)v4, (float)vAvg);
            quad.setSprite(TextureAtlasSprite2);
            this.setVertex(quad, 0, 0.0f, 0.0f + h1, 0.0f, u1, v1);
            this.setVertex(quad, 1, 0.0f, 0.0f + h2, 1.0f, u2, v2);
            this.setVertex(quad, 2, 1.0f, 0.0f + h3, 1.0f, u3, v3);
            this.setVertex(quad, 3, 1.0f, 0.0f + h4, 0.0f, u4, v4);
            this.calculateQuadColors(quad, world, pos, lighter, Direction.UP, 1.0f, colored);
            this.flushQuad(consumer, quad, Direction.UP, false);
            if (fluidState.func_205586_a((IBlockReader)world, (BlockPos)this.scratchPos.func_181079_c(posX, posY + 1, posZ))) {
                this.setVertex(quad, 3, 0.0f, 0.0f + h1, 0.0f, u1, v1);
                this.setVertex(quad, 2, 0.0f, 0.0f + h2, 1.0f, u2, v2);
                this.setVertex(quad, 1, 1.0f, 0.0f + h3, 1.0f, u3, v3);
                this.setVertex(quad, 0, 1.0f, 0.0f + h4, 0.0f, u4, v4);
                this.flushQuad(consumer, quad, Direction.DOWN, true);
            }
            rendered = true;
        }
        if (sfDown) {
            TextureAtlasSprite TextureAtlasSprite3 = sprites[0];
            float minU = TextureAtlasSprite3.func_94209_e();
            float maxU = TextureAtlasSprite3.func_94212_f();
            float minV = TextureAtlasSprite3.func_94206_g();
            float maxV = TextureAtlasSprite3.func_94210_h();
            quad.setSprite(TextureAtlasSprite3);
            this.setVertex(quad, 0, 0.0f, 0.0f + yOffset, 1.0f, minU, maxV);
            this.setVertex(quad, 1, 0.0f, 0.0f + yOffset, 0.0f, minU, minV);
            this.setVertex(quad, 2, 1.0f, 0.0f + yOffset, 0.0f, maxU, minV);
            this.setVertex(quad, 3, 1.0f, 0.0f + yOffset, 1.0f, maxU, maxV);
            this.calculateQuadColors(quad, world, pos, lighter, Direction.DOWN, 1.0f, colored);
            this.flushQuad(consumer, quad, Direction.DOWN, false);
            rendered = true;
        }
        this.quad.setFlags(1);
        block6: for (Direction dir : DirectionUtil.HORIZONTAL_DIRECTIONS) {
            BlockPos.Mutable posAdj;
            Block block;
            float z2;
            float z1;
            float x2;
            float x1;
            float c2;
            float c1;
            switch (dir) {
                case NORTH: {
                    if (!sfNorth) continue block6;
                    c1 = h1;
                    c2 = h4;
                    x1 = 0.0f;
                    x2 = 1.0f;
                    z2 = z1 = 0.001f;
                    break;
                }
                case SOUTH: {
                    if (!sfSouth) continue block6;
                    c1 = h3;
                    c2 = h2;
                    x1 = 1.0f;
                    x2 = 0.0f;
                    z2 = z1 = 0.999f;
                    break;
                }
                case WEST: {
                    if (!sfWest) continue block6;
                    c1 = h2;
                    c2 = h1;
                    x2 = x1 = 0.001f;
                    z1 = 1.0f;
                    z2 = 0.0f;
                    break;
                }
                case EAST: {
                    if (!sfEast) continue block6;
                    c1 = h4;
                    c2 = h3;
                    x2 = x1 = 0.999f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                default: {
                    continue block6;
                }
            }
            if (!this.isSideExposed(world, posX, posY, posZ, dir, Math.max(c1, c2))) continue;
            int adjX = posX + dir.func_82601_c();
            int adjY = posY + dir.func_96559_d();
            int adjZ = posZ + dir.func_82599_e();
            TextureAtlasSprite TextureAtlasSprite4 = sprites[1];
            if (sprites[2] != null && ((block = world.func_180495_p((BlockPos)(posAdj = this.scratchPos.func_181079_c(adjX, adjY, adjZ))).func_177230_c()) == Blocks.field_150359_w || block instanceof StainedGlassBlock)) {
                TextureAtlasSprite4 = sprites[2];
            }
            float u1 = TextureAtlasSprite4.func_94214_a(0.0);
            float u2 = TextureAtlasSprite4.func_94214_a(8.0);
            float v1 = TextureAtlasSprite4.func_94207_b((double)((1.0f - c1) * 16.0f * 0.5f));
            float v2 = TextureAtlasSprite4.func_94207_b((double)((1.0f - c2) * 16.0f * 0.5f));
            float v3 = TextureAtlasSprite4.func_94207_b(8.0);
            quad.setSprite(TextureAtlasSprite4);
            this.setVertex(quad, 0, x2, 0.0f + c2, z2, u2, v2);
            this.setVertex(quad, 1, x2, 0.0f + yOffset, z2, u2, v3);
            this.setVertex(quad, 2, x1, 0.0f + yOffset, z1, u1, v3);
            this.setVertex(quad, 3, x1, 0.0f + c1, z1, u1, v1);
            float br = dir.func_176740_k() == Direction.Axis.Z ? 0.8f : 0.6f;
            this.calculateQuadColors(quad, world, pos, lighter, dir, br, colored);
            this.flushQuad(consumer, quad, dir, false);
            if (TextureAtlasSprite4 != sprites[2]) {
                this.setVertex(quad, 0, x1, 0.0f + c1, z1, u1, v1);
                this.setVertex(quad, 1, x1, 0.0f + yOffset, z1, u1, v3);
                this.setVertex(quad, 2, x2, 0.0f + yOffset, z2, u2, v3);
                this.setVertex(quad, 3, x2, 0.0f + c2, z2, u2, v2);
                this.flushQuad(consumer, quad, dir, true);
            }
            rendered = true;
        }
        return rendered;
    }

    private void calculateQuadColors(ModelQuadViewMutable quad, IBlockDisplayReader world, BlockPos pos, LightPipeline lighter, Direction dir, float brightness, boolean colorized) {
        QuadLightData light = this.quadLightData;
        lighter.calculate(quad, pos, light, dir, false);
        int[] biomeColors = null;
        if (colorized) {
            biomeColors = this.biomeColorBlender.getColors(FLUID_COLOR_PROVIDER, world, world.func_180495_p(pos), pos, quad);
        }
        for (int i = 0; i < 4; ++i) {
            this.quadColors[i] = ColorABGR.mul(biomeColors != null ? biomeColors[i] : -1, light.br[i] * brightness);
        }
    }

    private void flushQuad(ModelQuadSinkDelegate consumer, ModelQuadViewMutable quad, Direction dir, boolean flip) {
        int lightOrder;
        int vertexIdx;
        if (flip) {
            vertexIdx = 3;
            lightOrder = -1;
        } else {
            vertexIdx = 0;
            lightOrder = 1;
        }
        for (int i = 0; i < 4; ++i) {
            quad.setColor(i, this.quadColors[vertexIdx]);
            quad.setLight(i, this.quadLightData.lm[vertexIdx]);
            vertexIdx += lightOrder;
        }
        consumer.get(ModelQuadFacing.fromDirection(dir)).write(quad);
    }

    private void setVertex(ModelQuadViewMutable quad, int i, float x, float y, float z, float u, float v) {
        quad.setX(i, x);
        quad.setY(i, y);
        quad.setZ(i, z);
        quad.setTexU(i, u);
        quad.setTexV(i, v);
    }

    private float getCornerHeight(IBlockDisplayReader world, int x, int y, int z, Fluid fluid) {
        int samples = 0;
        float totalHeight = 0.0f;
        for (int i = 0; i < 4; ++i) {
            int x2 = x - (i & 1);
            int z2 = z - (i >> 1 & 1);
            if (world.func_204610_c((BlockPos)this.scratchPos.func_181079_c(x2, y + 1, z2)).func_206886_c().func_207187_a(fluid)) {
                return 1.0f;
            }
            BlockPos.Mutable pos = this.scratchPos.func_181079_c(x2, y, z2);
            BlockState blockState = world.func_180495_p((BlockPos)pos);
            FluidState fluidState = blockState.func_204520_s();
            if (fluidState.func_206886_c().func_207187_a(fluid)) {
                float height = fluidState.func_215679_a((IBlockReader)world, (BlockPos)pos);
                if (height >= 0.8f) {
                    totalHeight += height * 10.0f;
                    samples += 10;
                    continue;
                }
                totalHeight += height;
                ++samples;
                continue;
            }
            if (blockState.func_185904_a().func_76220_a()) continue;
            ++samples;
        }
        return totalHeight / (float)samples;
    }
}

