/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.pipeline;

import java.util.List;
import java.util.Random;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuad;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.BiomeColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadOrientation;
import me.jellysquid.mods.sodium.client.model.quad.sink.ModelQuadSinkDelegate;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.util.ModelQuadUtil;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.rand.XoRoShiRoRandom;
import me.jellysquid.mods.sodium.client.world.biome.BlockColorsExtended;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.IModelData;

public class BlockRenderer {
    private final Random random = new XoRoShiRoRandom();
    private final BlockColorsExtended blockColors;
    private final BlockOcclusionCache occlusionCache;
    private final ModelQuad cachedQuad = new ModelQuad();
    private final QuadLightData cachedQuadLightData = new QuadLightData();
    private final BiomeColorBlender biomeColorBlender;
    private final LightPipelineProvider lighters;
    private final boolean useAmbientOcclusion;

    public BlockRenderer(Minecraft client, LightPipelineProvider lighters, BiomeColorBlender biomeColorBlender) {
        this.blockColors = (BlockColorsExtended)client.func_184125_al();
        this.biomeColorBlender = biomeColorBlender;
        this.lighters = lighters;
        this.occlusionCache = new BlockOcclusionCache();
        this.useAmbientOcclusion = Minecraft.func_71379_u();
    }

    public boolean renderModel(IBlockDisplayReader world, BlockState state, BlockPos pos, IBakedModel model, ModelQuadSinkDelegate builder, boolean cull, long seed, IModelData modelData) {
        LightPipeline lighter = this.lighters.getLighter(this.getLightingMode(state, model));
        Vector3d offset = state.func_191059_e((IBlockReader)world, pos);
        modelData = model.getModelData(world, pos, state, modelData);
        boolean rendered = false;
        for (Direction dir : DirectionUtil.ALL_DIRECTIONS) {
            this.random.setSeed(seed);
            List sided = model.getQuads(state, dir, this.random, modelData);
            if (sided.isEmpty() || cull && !this.occlusionCache.shouldDrawSide(state, (IBlockReader)world, pos, dir)) continue;
            this.renderQuadList(world, state, pos, lighter, offset, builder, sided, ModelQuadFacing.fromDirection(dir));
            rendered = true;
        }
        this.random.setSeed(seed);
        List all = model.getQuads(state, null, this.random, modelData);
        if (!all.isEmpty()) {
            this.renderQuadList(world, state, pos, lighter, offset, builder, all, ModelQuadFacing.NONE);
            rendered = true;
        }
        return rendered;
    }

    private void renderQuadList(IBlockDisplayReader world, BlockState state, BlockPos pos, LightPipeline lighter, Vector3d offset, ModelQuadSinkDelegate builder, List<BakedQuad> quads, ModelQuadFacing facing) {
        IBlockColor colorizer = null;
        int quadsSize = quads.size();
        for (int i = 0; i < quadsSize; ++i) {
            BakedQuad quad = quads.get(i);
            QuadLightData light = this.cachedQuadLightData;
            lighter.calculate((ModelQuadView)quad, pos, light, quad.func_178210_d(), quad.func_239287_f_());
            if (quad.func_178212_b() && colorizer == null) {
                colorizer = this.blockColors.getColorProvider(state);
            }
            this.renderQuad(world, state, pos, builder, offset, colorizer, quad, light, facing);
        }
    }

    private void renderQuad(IBlockDisplayReader world, BlockState state, BlockPos pos, ModelQuadSinkDelegate consumer, Vector3d offset, IBlockColor colorProvider, BakedQuad bakedQuad, QuadLightData light, ModelQuadFacing facing) {
        ModelQuadView src = (ModelQuadView)bakedQuad;
        ModelQuadOrientation order = ModelQuadOrientation.orient(light.br);
        ModelQuad copy = this.cachedQuad;
        int norm = ModelQuadUtil.getFacingNormal(bakedQuad.func_178210_d());
        int[] colors = null;
        if (bakedQuad.func_178212_b()) {
            colors = this.biomeColorBlender.getColors(colorProvider, world, state, pos, src);
        }
        for (int dstIndex = 0; dstIndex < 4; ++dstIndex) {
            int srcIndex = order.getVertexIndex(dstIndex);
            copy.setX(dstIndex, src.getX(srcIndex) + (float)offset.func_82615_a());
            copy.setY(dstIndex, src.getY(srcIndex) + (float)offset.func_82617_b());
            copy.setZ(dstIndex, src.getZ(srcIndex) + (float)offset.func_82616_c());
            copy.setColor(dstIndex, ColorABGR.mul(colors != null ? colors[srcIndex] : -1, light.br[srcIndex]));
            copy.setTexU(dstIndex, src.getTexU(srcIndex));
            copy.setTexV(dstIndex, src.getTexV(srcIndex));
            copy.setLight(dstIndex, light.lm[srcIndex]);
            copy.setNormal(dstIndex, norm);
            copy.setSprite(src.getSprite());
        }
        consumer.get(facing).write(copy);
    }

    private LightMode getLightingMode(BlockState state, IBakedModel model) {
        if (this.useAmbientOcclusion && model.func_177555_b() && state.func_185906_d() == 0) {
            return LightMode.SMOOTH;
        }
        return LightMode.FLAT;
    }
}

