/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.tasks;

import java.util.Objects;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.render.pipeline.context.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.util.task.CancellationSource;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ChunkRenderRebuildTask<T extends ChunkGraphicsState>
extends ChunkRenderBuildTask<T> {
    private final ChunkRenderBackend<T> renderBackend;
    private final ChunkRenderContainer<T> render;
    private final ChunkBuilder<T> chunkBuilder;
    private final Vector3d camera;
    private final WorldSlice slice;
    private final BlockPos offset;

    public ChunkRenderRebuildTask(ChunkBuilder<T> chunkBuilder, ChunkRenderBackend<T> renderBackend, ChunkRenderContainer<T> render, WorldSlice slice) {
        this.renderBackend = renderBackend;
        this.chunkBuilder = chunkBuilder;
        this.render = render;
        this.camera = chunkBuilder.getCameraPosition();
        this.slice = slice;
        this.offset = render.getRenderOrigin();
    }

    @Override
    public ChunkBuildResult<T> performBuild(ChunkRenderContext pipeline, ChunkBuildBuffers buffers, CancellationSource cancellationSource) {
        ChunkRenderData.Builder renderData = new ChunkRenderData.Builder();
        VisGraph occluder = new VisGraph();
        ChunkRenderBounds.Builder bounds = new ChunkRenderBounds.Builder();
        pipeline.init(this.slice, this.slice.getBlockOffsetX(), this.slice.getBlockOffsetY(), this.slice.getBlockOffsetZ());
        buffers.init(renderData);
        int minX = this.render.getOriginX();
        int minY = this.render.getOriginY();
        int minZ = this.render.getOriginZ();
        int maxX = minX + 16;
        int maxY = minY + 16;
        int maxZ = minZ + 16;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        BlockPos offset = this.offset;
        for (int y = minY; y < maxY; ++y) {
            if (cancellationSource.isCancelled()) {
                return null;
            }
            for (int z = minZ; z < maxZ; ++z) {
                for (int x = minX; x < maxX; ++x) {
                    TileEntityRenderer renderer;
                    TileEntity entity;
                    FluidState fluidState;
                    ChunkBuildBuffers.ChunkBuildBufferDelegate builder;
                    BlockState blockState = this.slice.getBlockState(x, y, z);
                    Block block = blockState.func_177230_c();
                    if (blockState.func_196958_f()) continue;
                    pos.func_181079_c(x, y, z);
                    if (block.func_149645_b(blockState) == BlockRenderType.MODEL) {
                        for (RenderType layer : RenderType.func_228661_n_()) {
                            if (!RenderTypeLookup.canRenderInLayer((BlockState)blockState, (RenderType)layer)) continue;
                            ForgeHooksClient.setRenderLayer((RenderType)layer);
                            builder = buffers.get(layer);
                            builder.setOffset(x - offset.func_177958_n(), y - offset.func_177956_o(), z - offset.func_177952_p());
                            IModelData modelData = ModelDataManager.getModelData((World)((World)Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e)), (BlockPos)pos);
                            if (modelData == null) {
                                modelData = EmptyModelData.INSTANCE;
                            }
                            if (pipeline.renderBlock(this.slice, blockState, (BlockPos)pos, builder, true, modelData)) {
                                bounds.addBlock(x, y, z);
                            }
                            ForgeHooksClient.setRenderLayer(null);
                        }
                    }
                    if (!(fluidState = block.func_204507_t(blockState)).func_206888_e()) {
                        RenderType layer;
                        layer = RenderTypeLookup.func_228391_a_((FluidState)fluidState);
                        builder = buffers.get(layer);
                        builder.setOffset(x - offset.func_177958_n(), y - offset.func_177956_o(), z - offset.func_177952_p());
                        if (pipeline.renderFluid(this.slice, fluidState, pos, builder)) {
                            bounds.addBlock(x, y, z);
                        }
                    }
                    if (blockState.hasTileEntity() && (entity = this.slice.getBlockEntity((BlockPos)pos, Chunk.CreateEntityType.CHECK)) != null && (renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(entity)) != null) {
                        renderData.addBlockEntity(entity, !renderer.func_188185_a(entity));
                        bounds.addBlock(x, y, z);
                    }
                    if (!blockState.func_200015_d((IBlockReader)this.slice, (BlockPos)pos)) continue;
                    occluder.func_178606_a((BlockPos)pos);
                }
            }
        }
        for (BlockRenderPass pass : this.renderBackend.getRenderPassManager().getSortedPasses()) {
            ChunkMeshData mesh = buffers.createMesh(pass);
            if (mesh == null) continue;
            renderData.setMesh(pass, mesh);
        }
        renderData.setOcclusionData(occluder.func_178607_a());
        renderData.setBounds(bounds.build(this.render.getChunkPos()));
        return new ChunkBuildResult<T>(this.render, renderData.build());
    }

    @Override
    public void releaseResources() {
        this.chunkBuilder.releaseWorldSlice(this.slice);
    }
}

