/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.shader.texture;

import me.jellysquid.mods.sodium.client.gl.sampler.GlSampler;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkProgram;
import me.jellysquid.mods.sodium.client.render.chunk.shader.texture.ChunkProgramTextureComponent;
import me.jellysquid.mods.sodium.client.render.chunk.shader.texture.ChunkProgramTextureUnit;
import me.jellysquid.mods.sodium.client.render.chunk.shader.texture.LightmapTextureManagerAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.inventory.container.PlayerContainer;

public class ChunkProgramMultiTexture
extends ChunkProgramTextureComponent {
    private final int uBlockTex;
    private final int uBlockMippedTex;
    private final int uLightTex;
    private final GlSampler blockTexSampler;
    private final GlSampler blockTexMippedSampler;
    private final GlSampler lightTexSampler;

    public ChunkProgramMultiTexture(ChunkProgram program) {
        this.uBlockTex = program.getUniformLocation("u_BlockTex");
        this.uBlockMippedTex = program.getUniformLocation("u_BlockTexMipped");
        this.uLightTex = program.getUniformLocation("u_LightTex");
        this.blockTexSampler = new GlSampler();
        this.blockTexSampler.setParameter(10241, 9728);
        this.blockTexSampler.setParameter(10240, 9728);
        this.blockTexMippedSampler = new GlSampler();
        this.blockTexMippedSampler.setParameter(10241, 9986);
        this.blockTexMippedSampler.setParameter(10240, 9728);
        this.lightTexSampler = new GlSampler();
        this.lightTexSampler.setParameter(10241, 9729);
        this.lightTexSampler.setParameter(10240, 9729);
        this.lightTexSampler.setParameter(10242, 10496);
        this.lightTexSampler.setParameter(10243, 10496);
    }

    @Override
    public void bind() {
        Minecraft client = Minecraft.func_71410_x();
        TextureManager textureManager = client.func_110434_K();
        LightmapTextureManagerAccessor lightmapTextureManager = (LightmapTextureManagerAccessor)client.field_71460_t.func_228384_l_();
        Texture blockAtlasTex = textureManager.func_229267_b_(PlayerContainer.field_226615_c_);
        Texture lightTex = lightmapTextureManager.getTexture();
        this.bindTexture(blockAtlasTex, ChunkProgramTextureUnit.BLOCK_ATLAS);
        this.bindTexture(blockAtlasTex, ChunkProgramTextureUnit.BLOCK_ATLAS_MIPPED);
        this.bindTexture(lightTex, ChunkProgramTextureUnit.LIGHT_TEX);
        this.blockTexSampler.bindToTextureUnit(ChunkProgramTextureUnit.BLOCK_ATLAS.ordinal());
        this.blockTexMippedSampler.bindToTextureUnit(ChunkProgramTextureUnit.BLOCK_ATLAS_MIPPED.ordinal());
        this.lightTexSampler.bindToTextureUnit(ChunkProgramTextureUnit.LIGHT_TEX.ordinal());
        this.bindUniform(this.uBlockTex, ChunkProgramTextureUnit.BLOCK_ATLAS);
        this.bindUniform(this.uBlockMippedTex, ChunkProgramTextureUnit.BLOCK_ATLAS_MIPPED);
        this.bindUniform(this.uLightTex, ChunkProgramTextureUnit.LIGHT_TEX);
    }

    @Override
    public void unbind() {
        this.blockTexSampler.unbindFromTextureUnit(ChunkProgramTextureUnit.BLOCK_ATLAS.ordinal());
        this.blockTexMippedSampler.unbindFromTextureUnit(ChunkProgramTextureUnit.BLOCK_ATLAS.ordinal());
        this.blockTexSampler.unbindFromTextureUnit(ChunkProgramTextureUnit.LIGHT_TEX.ordinal());
    }

    @Override
    public void delete() {
        this.blockTexSampler.delete();
        this.blockTexMippedSampler.delete();
    }

    @Override
    public void setMipmapping(boolean mipped) {
    }
}

