/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.shader;

import java.nio.FloatBuffer;
import me.jellysquid.mods.sodium.client.gl.util.GlFogHelper;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkProgram;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ShaderComponent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.system.MemoryStack;

public abstract class ChunkShaderFogComponent
implements ShaderComponent {
    @Override
    public void unbind() {
    }

    @Override
    public void delete() {
    }

    private static void setupColorUniform(int index) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer bufFogColor = stack.mallocFloat(4);
            GL11.glGetFloatv((int)2918, (FloatBuffer)bufFogColor);
            GL20.glUniform4fv((int)index, (FloatBuffer)bufFogColor);
        }
    }

    public static interface Factory {
        public ChunkShaderFogComponent create(ChunkProgram var1);
    }

    public static class Linear
    extends ChunkShaderFogComponent {
        private final int uFogColor;
        private final int uFogLength;
        private final int uFogEnd;

        public Linear(ChunkProgram program) {
            this.uFogColor = program.getUniformLocation("u_FogColor");
            this.uFogLength = program.getUniformLocation("u_FogLength");
            this.uFogEnd = program.getUniformLocation("u_FogEnd");
        }

        @Override
        public void bind() {
            ChunkShaderFogComponent.setupColorUniform(this.uFogColor);
            float end = GlFogHelper.getFogEnd();
            float start = GlFogHelper.getFogStart();
            GL20.glUniform1f((int)this.uFogLength, (float)(end - start));
            GL20.glUniform1f((int)this.uFogEnd, (float)end);
        }
    }

    public static class Exp2
    extends ChunkShaderFogComponent {
        private final int uFogColor;
        private final int uFogDensity;

        public Exp2(ChunkProgram program) {
            this.uFogColor = program.getUniformLocation("u_FogColor");
            this.uFogDensity = program.getUniformLocation("u_FogDensity");
        }

        @Override
        public void bind() {
            ChunkShaderFogComponent.setupColorUniform(this.uFogColor);
            GL20.glUniform1f((int)this.uFogDensity, (float)GlFogHelper.getFogDensity());
        }
    }

    public static class None
    extends ChunkShaderFogComponent {
        public None(ChunkProgram program) {
        }

        @Override
        public void bind() {
        }
    }
}

