/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.shader;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.EnumMap;
import me.jellysquid.mods.sodium.client.gl.SodiumVertexFormats;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.gl.shader.GlShader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderConstants;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderLoader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderType;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkFogMode;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkProgram;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkProgramComponentBuilder;
import net.minecraft.util.ResourceLocation;

public abstract class ChunkRenderShaderBackend<T extends ChunkGraphicsState, P extends ChunkProgram>
implements ChunkRenderBackend<T> {
    private final EnumMap<ChunkFogMode, P> programs = new EnumMap(ChunkFogMode.class);
    protected final GlVertexFormat<SodiumVertexFormats.ChunkMeshAttribute> vertexFormat;
    protected P activeProgram;

    public ChunkRenderShaderBackend(GlVertexFormat<SodiumVertexFormats.ChunkMeshAttribute> format) {
        this.vertexFormat = format;
    }

    @Override
    public final void createShaders() {
        this.programs.put(ChunkFogMode.NONE, this.createShader(ChunkFogMode.NONE, this.vertexFormat));
        this.programs.put(ChunkFogMode.LINEAR, this.createShader(ChunkFogMode.LINEAR, this.vertexFormat));
        this.programs.put(ChunkFogMode.EXP2, this.createShader(ChunkFogMode.EXP2, this.vertexFormat));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private P createShader(ChunkFogMode fogMode, GlVertexFormat<SodiumVertexFormats.ChunkMeshAttribute> format) {
        GlShader vertShader = this.createVertexShader(fogMode);
        GlShader fragShader = this.createFragmentShader(fogMode);
        ChunkProgramComponentBuilder components = new ChunkProgramComponentBuilder();
        components.fog = fogMode.getFactory();
        try {
            GlProgram.Builder builder = GlProgram.builder(new ResourceLocation("sodium", "chunk_shader"));
            builder.attachShader(vertShader);
            builder.attachShader(fragShader);
            builder.bindAttribute("a_Pos", format.getAttribute(SodiumVertexFormats.ChunkMeshAttribute.POSITION));
            builder.bindAttribute("a_Color", format.getAttribute(SodiumVertexFormats.ChunkMeshAttribute.COLOR));
            builder.bindAttribute("a_TexCoord", format.getAttribute(SodiumVertexFormats.ChunkMeshAttribute.TEXTURE));
            builder.bindAttribute("a_LightCoord", format.getAttribute(SodiumVertexFormats.ChunkMeshAttribute.LIGHT));
            this.modifyProgram(builder, components, format);
            ChunkProgram chunkProgram = builder.build((program, name) -> this.createShaderProgram(program, name, components));
            return (P)chunkProgram;
        }
        finally {
            vertShader.delete();
            fragShader.delete();
        }
    }

    protected abstract void modifyProgram(GlProgram.Builder var1, ChunkProgramComponentBuilder var2, GlVertexFormat<SodiumVertexFormats.ChunkMeshAttribute> var3);

    private GlShader createVertexShader(ChunkFogMode fogMode) {
        return ShaderLoader.loadShader(ShaderType.VERTEX, new ResourceLocation("sodium", "chunk_glsl110.v.glsl"), this.createShaderConstants(fogMode));
    }

    private GlShader createFragmentShader(ChunkFogMode fogMode) {
        return ShaderLoader.loadShader(ShaderType.FRAGMENT, new ResourceLocation("sodium", "chunk_glsl110.f.glsl"), this.createShaderConstants(fogMode));
    }

    private ShaderConstants createShaderConstants(ChunkFogMode fogMode) {
        ShaderConstants.Builder builder = ShaderConstants.builder();
        fogMode.addConstants(builder);
        this.addShaderConstants(builder);
        return builder.build();
    }

    protected abstract void addShaderConstants(ShaderConstants.Builder var1);

    protected abstract P createShaderProgram(ResourceLocation var1, int var2, ChunkProgramComponentBuilder var3);

    protected void beginRender(MatrixStack matrixStack, BlockRenderPass pass) {
        this.activeProgram = (ChunkProgram)this.programs.get((Object)ChunkFogMode.getActiveMode());
        ((ChunkProgram)this.activeProgram).bind(matrixStack);
    }

    protected void endRender(MatrixStack matrixStack) {
        ((ChunkProgram)this.activeProgram).unbind();
    }

    @Override
    public void delete() {
        for (ChunkProgram shader : this.programs.values()) {
            shader.delete();
        }
    }

    @Override
    public GlVertexFormat<SodiumVertexFormats.ChunkMeshAttribute> getVertexFormat() {
        return this.vertexFormat;
    }
}

