/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.shader;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.nio.FloatBuffer;
import java.util.List;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkProgramComponentBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderFogComponent;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ShaderComponent;
import me.jellysquid.mods.sodium.client.render.chunk.shader.texture.ChunkProgramTextureComponent;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.system.MemoryStack;

public abstract class ChunkProgram
extends GlProgram {
    protected static final float MODEL_SIZE = 32.0f;
    private final int uModelViewProjectionMatrix = this.getUniformLocation("u_ModelViewProjectionMatrix");
    private final int uModelScale = this.getUniformLocation("u_ModelScale");
    public final ChunkProgramTextureComponent texture;
    public final ChunkShaderFogComponent fog;
    private final List<ShaderComponent> components;

    protected ChunkProgram(ResourceLocation name, int handle, ChunkProgramComponentBuilder components) {
        super(name, handle);
        this.texture = components.texture.create(this);
        this.fog = components.fog.create(this);
        this.components = ImmutableList.of((Object)this.texture, (Object)this.fog);
    }

    @Override
    public void bind(MatrixStack matrixStack) {
        super.bind(matrixStack);
        for (ShaderComponent component : this.components) {
            component.bind();
        }
        GL20.glUniform3f((int)this.uModelScale, (float)32.0f, (float)32.0f, (float)32.0f);
        MatrixStack.Entry matrices = matrixStack.func_227866_c_();
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer bufProjection = stack.mallocFloat(16);
            FloatBuffer bufModelView = stack.mallocFloat(16);
            FloatBuffer bufModelViewProjection = stack.mallocFloat(16);
            GL15.glGetFloatv((int)2983, (FloatBuffer)bufProjection);
            matrices.func_227870_a_().func_195879_b(bufModelView);
            GL11.glPushMatrix();
            GL11.glLoadMatrixf((FloatBuffer)bufProjection);
            GL11.glMultMatrixf((FloatBuffer)bufModelView);
            GL15.glGetFloatv((int)2982, (FloatBuffer)bufModelViewProjection);
            GL11.glPopMatrix();
            GL20.glUniformMatrix4fv((int)this.uModelViewProjectionMatrix, (boolean)false, (FloatBuffer)bufModelViewProjection);
        }
    }

    @Override
    public void unbind() {
        super.unbind();
        for (ShaderComponent component : this.components) {
            component.unbind();
        }
    }

    @Override
    public void delete() {
        super.delete();
        for (ShaderComponent component : this.components) {
            component.delete();
        }
    }
}

