/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.passes;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockLayer;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.passes.WorldRenderPhase;
import net.minecraft.util.ResourceLocation;

public class BlockRenderPassManager {
    private final EnumMap<WorldRenderPhase, List<BlockRenderPass>> byPhase = new EnumMap(WorldRenderPhase.class);
    private final List<BlockRenderPass> all = new ArrayList<BlockRenderPass>();

    public BlockRenderPassManager() {
        for (WorldRenderPhase pass : WorldRenderPhase.values()) {
            this.byPhase.put(pass, new ArrayList());
        }
    }

    public <R extends BlockRenderPass> void add(WorldRenderPhase phase, ResourceLocation id, Factory<R> factory, BlockLayer ... layers) {
        BlockRenderPass pass = (BlockRenderPass)factory.create(this.all.size(), id, layers);
        this.byPhase.get((Object)phase).add(pass);
        this.all.add(pass);
    }

    public Iterable<BlockRenderPass> getSortedPasses() {
        return this.all;
    }

    public Iterable<BlockRenderPass> getPassesForPhase(WorldRenderPhase phase) {
        return this.byPhase.get((Object)phase);
    }

    public int getPassCount() {
        return this.all.size();
    }

    public static interface Factory<R> {
        public R create(int var1, ResourceLocation var2, BlockLayer[] var3);
    }
}

