/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.passes;

import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import net.minecraft.client.renderer.RenderType;

public enum BlockLayer {
    SOLID_MIPPED(true),
    SOLID(false),
    TRANSLUCENT_MIPPED(true);

    public static final BlockLayer[] VALUES;
    public static final int COUNT;
    private final boolean mipped;
    private static final Reference2IntArrayMap<RenderType> layerMappings;

    private BlockLayer(boolean mipped) {
        this.mipped = mipped;
    }

    public boolean isMipped() {
        return this.mipped;
    }

    public int getExpectedSize() {
        return 0x200000;
    }

    public static int fromRenderType(RenderType layer) {
        int pass = layerMappings.getInt((Object)layer);
        if (pass < 0) {
            throw new NullPointerException("No render pass exists for layer: " + layer);
        }
        return pass;
    }

    static {
        VALUES = BlockLayer.values();
        COUNT = VALUES.length;
        layerMappings = new Reference2IntArrayMap();
        layerMappings.defaultReturnValue(-1);
        layerMappings.put((Object)RenderType.func_228639_c_(), SOLID_MIPPED.ordinal());
        layerMappings.put((Object)RenderType.func_228641_d_(), SOLID_MIPPED.ordinal());
        layerMappings.put((Object)RenderType.func_228643_e_(), SOLID.ordinal());
        layerMappings.put((Object)RenderType.func_241715_r_(), SOLID.ordinal());
        layerMappings.put((Object)RenderType.func_228645_f_(), TRANSLUCENT_MIPPED.ordinal());
    }
}

