/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.gl.buffer.VertexData;
import me.jellysquid.mods.sodium.client.gl.util.BufferSlice;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.sink.ModelQuadSinkDelegate;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkMeshBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockLayer;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderType;

public class ChunkBuildBuffers {
    private final ChunkBuildBufferDelegate[] delegates;
    private final ChunkMeshBuilder[][] buildersByPass;
    private final List<ChunkMeshBuilder> builders;
    private final GlVertexFormat<?> format;

    public ChunkBuildBuffers(GlVertexFormat<?> format) {
        this.format = format;
        this.delegates = new ChunkBuildBufferDelegate[BlockLayer.COUNT];
        this.buildersByPass = new ChunkMeshBuilder[BlockLayer.COUNT][ModelQuadFacing.COUNT];
        for (BlockLayer layer : BlockLayer.VALUES) {
            for (ModelQuadFacing facing : ModelQuadFacing.VALUES) {
                this.buildersByPass[layer.ordinal()][facing.ordinal()] = new ChunkMeshBuilder(format, layer, layer.getExpectedSize() / ModelQuadFacing.COUNT);
            }
            this.delegates[layer.ordinal()] = new ChunkBuildBufferDelegate(this.buildersByPass[layer.ordinal()]);
        }
        this.builders = Arrays.stream(this.buildersByPass).flatMap(Arrays::stream).collect(Collectors.toList());
    }

    public ChunkBuildBufferDelegate get(RenderType layer) {
        return this.delegates[BlockLayer.fromRenderType(layer)];
    }

    /*
     * WARNING - void declaration
     */
    public ChunkMeshData createMesh(BlockRenderPass pass) {
        void var6_8;
        ChunkMeshData meshData = new ChunkMeshData();
        int meshSize = 0;
        ModelQuadFacing[] modelQuadFacingArray = ModelQuadFacing.VALUES;
        int n = modelQuadFacingArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            ModelQuadFacing facing = modelQuadFacingArray[var6_8];
            int facingSize = 0;
            BlockLayer[] blockLayerArray = pass.getLayers();
            int n2 = blockLayerArray.length;
            for (int i = 0; i < n2; ++i) {
                BlockLayer layer = blockLayerArray[i];
                ChunkMeshBuilder builder = this.buildersByPass[layer.ordinal()][facing.ordinal()];
                builder.finish();
                facingSize += builder.getSize();
            }
            meshData.setModelSlice(facing, new BufferSlice(meshSize, facingSize));
            meshSize += facingSize;
            ++var6_8;
        }
        if (meshSize <= 0) {
            return null;
        }
        ByteBuffer buffer = GLAllocation.func_74524_c((int)meshSize);
        for (Map.Entry<ModelQuadFacing, BufferSlice> entry : meshData.getSlices()) {
            ModelQuadFacing key = entry.getKey();
            for (BlockLayer layer : pass.getLayers()) {
                ChunkMeshBuilder builder = this.buildersByPass[layer.ordinal()][key.ordinal()];
                if (builder.isEmpty()) continue;
                builder.copyInto(buffer);
            }
        }
        buffer.flip();
        meshData.setVertexData(new VertexData(buffer, this.format));
        return meshData;
    }

    public void init(ChunkRenderData.Builder renderData) {
        for (ChunkMeshBuilder builder : this.builders) {
            builder.begin(renderData);
        }
    }

    public static class ChunkBuildBufferDelegate
    implements ModelQuadSinkDelegate {
        private final ChunkMeshBuilder[] builders;

        private ChunkBuildBufferDelegate(ChunkMeshBuilder[] builders) {
            this.builders = builders;
        }

        @Override
        public ChunkMeshBuilder get(ModelQuadFacing facing) {
            return this.builders[facing.ordinal()];
        }

        public void setOffset(int x, int y, int z) {
            for (ChunkMeshBuilder builder : this.builders) {
                builder.setOffset(x, y, z);
            }
        }
    }
}

