/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.backends.gl43;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import me.jellysquid.mods.sodium.client.gl.SodiumVertexFormats;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferArena;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferRegion;
import me.jellysquid.mods.sodium.client.gl.array.GlVertexArray;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.GlMutableBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.VertexData;
import me.jellysquid.mods.sodium.client.gl.func.GlFunctions;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderConstants;
import me.jellysquid.mods.sodium.client.gl.util.BufferSlice;
import me.jellysquid.mods.sodium.client.gl.util.GlVendorUtil;
import me.jellysquid.mods.sodium.client.gl.util.MemoryTracker;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkCameraContext;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.backends.gl43.GL43GraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.backends.gl43.IndirectCommandBufferVector;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderListIterator;
import me.jellysquid.mods.sodium.client.render.chunk.multidraw.ChunkDrawCallBatcher;
import me.jellysquid.mods.sodium.client.render.chunk.multidraw.ChunkDrawParamsVector;
import me.jellysquid.mods.sodium.client.render.chunk.multidraw.ChunkProgramMultiDraw;
import me.jellysquid.mods.sodium.client.render.chunk.multidraw.ChunkRenderBackendMultiDraw;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPassManager;
import me.jellysquid.mods.sodium.client.render.chunk.passes.impl.MultiTextureRenderPipeline;
import me.jellysquid.mods.sodium.client.render.chunk.region.ChunkRegion;
import me.jellysquid.mods.sodium.client.render.chunk.region.ChunkRegionManager;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkProgramComponentBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.shader.texture.ChunkProgramMultiTexture;
import org.lwjgl.opengl.GL20;

public class GL43ChunkRenderBackend
extends ChunkRenderBackendMultiDraw<GL43GraphicsState> {
    private final BlockRenderPassManager renderPassManager;
    private final ChunkRegionManager<GL43GraphicsState> bufferManager;
    private final ObjectArrayList<ChunkRegion<GL43GraphicsState>> pendingBatches = new ObjectArrayList();
    private final ObjectArrayFIFOQueue<ChunkRegion<GL43GraphicsState>> pendingUploads = new ObjectArrayFIFOQueue();
    private final GlMutableBuffer uploadBuffer;
    private final GlMutableBuffer uniformBuffer;
    private final GlMutableBuffer commandBuffer;
    private final ChunkDrawParamsVector uniformBufferBuilder;
    private final IndirectCommandBufferVector commandBufferBuilder;
    private final MemoryTracker memoryTracker = new MemoryTracker();

    public GL43ChunkRenderBackend(GlVertexFormat<SodiumVertexFormats.ChunkMeshAttribute> format) {
        super(format);
        this.renderPassManager = MultiTextureRenderPipeline.create();
        this.bufferManager = new ChunkRegionManager(this.memoryTracker);
        this.uploadBuffer = new GlMutableBuffer(35042);
        this.uniformBuffer = new GlMutableBuffer(35044);
        this.commandBuffer = new GlMutableBuffer(35044);
        this.uniformBufferBuilder = ChunkDrawParamsVector.create(2048);
        this.commandBufferBuilder = IndirectCommandBufferVector.create(2048);
    }

    @Override
    protected void modifyProgram(GlProgram.Builder builder, ChunkProgramComponentBuilder components, GlVertexFormat<SodiumVertexFormats.ChunkMeshAttribute> format) {
        components.texture = ChunkProgramMultiTexture::new;
    }

    @Override
    protected void addShaderConstants(ShaderConstants.Builder builder) {
        super.addShaderConstants(builder);
        builder.define("USE_MULTITEX");
    }

    @Override
    public void uploadChunks(Iterator<ChunkBuildResult<GL43GraphicsState>> queue) {
        this.setupUploadBatches(queue);
        GlMutableBuffer uploadBuffer = this.uploadBuffer;
        uploadBuffer.bind(34962);
        while (!this.pendingUploads.isEmpty()) {
            ChunkRegion region = (ChunkRegion)this.pendingUploads.dequeue();
            GlBufferArena arena = region.getBufferArena();
            arena.bind();
            ObjectArrayList uploadQueue = region.getUploadQueue();
            arena.ensureCapacity(GL43ChunkRenderBackend.getUploadQueuePayloadSize(uploadQueue));
            for (ChunkBuildResult result : uploadQueue) {
                ChunkRenderContainer<GL43GraphicsState> render = result.render;
                ChunkRenderData data = result.data;
                for (BlockRenderPass pass : this.renderPassManager.getSortedPasses()) {
                    ChunkMeshData meshData;
                    GL43GraphicsState graphics = (GL43GraphicsState)render.getGraphicsState(pass);
                    if (graphics != null) {
                        graphics.delete();
                    }
                    if ((meshData = data.getMesh(pass)) != null) {
                        VertexData upload = meshData.takeVertexData();
                        uploadBuffer.upload(34962, upload);
                        GlBufferRegion segment = arena.upload(34962, 0, upload.buffer.capacity());
                        render.setGraphicsState(pass, new GL43GraphicsState(render, region, segment, meshData, this.vertexFormat));
                        continue;
                    }
                    render.setGraphicsState(pass, null);
                }
                render.setData(data);
            }
            arena.unbind();
            uploadQueue.clear();
        }
        uploadBuffer.invalidate(34962);
        uploadBuffer.unbind(34962);
    }

    @Override
    public void renderChunks(MatrixStack matrixStack, BlockRenderPass pass, ChunkRenderListIterator<GL43GraphicsState> renders, ChunkCameraContext camera) {
        this.beginRender(matrixStack, pass);
        this.bufferManager.cleanup();
        this.setupDrawBatches(renders, camera);
        this.setupCommandBuffers();
        GlVertexArray prevVao = null;
        int commandStart = 0;
        for (ChunkRegion region : this.pendingBatches) {
            GlVertexArray vao = region.getVertexArray();
            vao.bind();
            if (region.isDirty()) {
                this.setupArrayBufferState(region.getBufferArena());
                this.setupUniformBufferState();
                region.markClean();
            }
            ChunkDrawCallBatcher batch = region.getDrawBatcher();
            int commandCount = batch.getCount();
            GlFunctions.INDIRECT_DRAW.glMultiDrawArraysIndirect(7, commandStart << 4, commandCount, 0);
            prevVao = vao;
            commandStart += commandCount;
        }
        this.pendingBatches.clear();
        if (prevVao != null) {
            prevVao.unbind();
        }
        this.uniformBuffer.unbind(34962);
        this.commandBuffer.unbind(36671);
        this.endRender(matrixStack);
    }

    private void setupCommandBuffers() {
        this.commandBufferBuilder.begin();
        for (ChunkRegion region : this.pendingBatches) {
            ChunkDrawCallBatcher batcher = region.getDrawBatcher();
            batcher.end();
            this.commandBufferBuilder.pushCommandBuffer(batcher.getBuffer());
        }
        this.commandBufferBuilder.end();
        this.commandBuffer.bind(36671);
        this.commandBuffer.upload(36671, this.commandBufferBuilder.getBuffer());
    }

    private void setupArrayBufferState(GlBufferArena arena) {
        GlBuffer vbo = arena.getBuffer();
        vbo.bind(34962);
        this.vertexFormat.bindVertexAttributes();
        this.vertexFormat.enableVertexAttributes();
    }

    private void setupUniformBufferState() {
        this.uniformBuffer.bind(34962);
        int index = ((ChunkProgramMultiDraw)this.activeProgram).getModelOffsetAttributeLocation();
        GL20.glVertexAttribPointer((int)index, (int)4, (int)5126, (boolean)false, (int)0, (long)0L);
        GlFunctions.INSTANCED_ARRAY.glVertexAttribDivisor(index, 1);
        GL20.glEnableVertexAttribArray((int)index);
    }

    private void setupUploadBatches(Iterator<ChunkBuildResult<GL43GraphicsState>> renders) {
        while (renders.hasNext()) {
            ObjectArrayList<ChunkBuildResult<GL43GraphicsState>> uploadQueue;
            ChunkBuildResult<GL43GraphicsState> result = renders.next();
            ChunkRenderContainer render = result.render;
            ChunkRegion<GL43GraphicsState> region = this.bufferManager.getRegion(render.getChunkX(), render.getChunkY(), render.getChunkZ());
            if (region == null) {
                if (result.data.getMeshSize() <= 0) {
                    render.setData(result.data);
                    continue;
                }
                region = this.bufferManager.getOrCreateRegion(render.getChunkX(), render.getChunkY(), render.getChunkZ());
            }
            if ((uploadQueue = region.getUploadQueue()).isEmpty()) {
                this.pendingUploads.enqueue(region);
            }
            uploadQueue.add(result);
        }
    }

    private void setupDrawBatches(ChunkRenderListIterator<GL43GraphicsState> it, ChunkCameraContext camera) {
        this.uniformBufferBuilder.reset();
        int drawCount = 0;
        while (it.hasNext()) {
            GL43GraphicsState state = it.getGraphicsState();
            int visible = it.getVisibleFaces();
            int index = drawCount++;
            float x = camera.getChunkModelOffset(state.getX(), camera.blockOriginX, camera.originX);
            float y = camera.getChunkModelOffset(state.getY(), camera.blockOriginY, camera.originY);
            float z = camera.getChunkModelOffset(state.getZ(), camera.blockOriginZ, camera.originZ);
            this.uniformBufferBuilder.pushChunkDrawParams(x, y, z);
            ChunkRegion<GL43GraphicsState> region = state.getRegion();
            ChunkDrawCallBatcher batch = region.getDrawBatcher();
            if (!batch.isBuilding()) {
                batch.begin();
                this.pendingBatches.add(region);
            }
            int mask = 1;
            for (int i = 0; i < ModelQuadFacing.COUNT; ++i) {
                if ((visible & mask) != 0) {
                    long part = state.getModelPart(i);
                    batch.addIndirectDrawCall(BufferSlice.unpackStart(part), BufferSlice.unpackLength(part), index, 1);
                }
                mask <<= 1;
            }
            it.advance();
        }
        this.uniformBuffer.bind(34962);
        this.uniformBuffer.upload(34962, this.uniformBufferBuilder.getBuffer());
    }

    private static int getUploadQueuePayloadSize(List<ChunkBuildResult<GL43GraphicsState>> queue) {
        int size = 0;
        for (ChunkBuildResult<GL43GraphicsState> result : queue) {
            size += result.data.getMeshSize();
        }
        return size;
    }

    @Override
    public void delete() {
        super.delete();
        this.bufferManager.delete();
        this.uploadBuffer.delete();
        this.uniformBuffer.delete();
        this.commandBuffer.delete();
        this.uniformBufferBuilder.delete();
        this.commandBufferBuilder.delete();
    }

    @Override
    public Class<GL43GraphicsState> getGraphicsStateType() {
        return GL43GraphicsState.class;
    }

    @Override
    public BlockRenderPassManager getRenderPassManager() {
        return this.renderPassManager;
    }

    public static boolean isSupported(boolean disableBlacklist) {
        if (!disableBlacklist && GlVendorUtil.matches("ATI Technologies Inc.")) {
            return false;
        }
        return GlFunctions.isVertexArraySupported() && GlFunctions.isBufferCopySupported() && GlFunctions.isIndirectMultiDrawSupported() && GlFunctions.isInstancedArraySupported();
    }

    @Override
    public String getRendererName() {
        return "Multidraw (GL 4.3)";
    }

    @Override
    public MemoryTracker getMemoryTracker() {
        return this.memoryTracker;
    }

    @Override
    public List<String> getDebugStrings() {
        return Lists.newArrayList((Object[])new String[]{"Allocated Regions: " + this.bufferManager.getAllocatedRegionCount()});
    }
}

