/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.backends.gl20;

import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.GlMutableBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.VertexData;
import me.jellysquid.mods.sodium.client.gl.util.MemoryTracker;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.oneshot.ChunkOneshotGraphicsState;

public class GL20GraphicsState
extends ChunkOneshotGraphicsState {
    private final GlBuffer vertexBuffer = new GlMutableBuffer(35044);
    private GlVertexFormat<?> vertexFormat;

    public GL20GraphicsState(MemoryTracker memoryTracker, ChunkRenderContainer<?> container) {
        super(memoryTracker, container);
    }

    @Override
    public void delete() {
        this.memoryTracker.onMemoryFreeAndRelease(this.vertexBuffer.getSize());
        this.vertexBuffer.delete();
    }

    @Override
    public void upload(ChunkMeshData meshData) {
        VertexData data = meshData.takeVertexData();
        this.vertexBuffer.bind(34962);
        this.memoryTracker.onMemoryFreeAndRelease(this.vertexBuffer.getSize());
        this.vertexBuffer.upload(34962, data);
        this.memoryTracker.onMemoryAllocateAndUse(this.vertexBuffer.getSize());
        this.vertexBuffer.unbind(34962);
        this.vertexFormat = data.format;
        this.setupModelParts(meshData, this.vertexFormat);
    }

    @Override
    public void bind() {
        this.vertexBuffer.bind(34962);
        this.vertexFormat.bindVertexAttributes();
    }
}

