/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import java.lang.reflect.Array;
import java.util.concurrent.CompletableFuture;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;

public class ChunkRenderContainer<T extends ChunkGraphicsState> {
    private final SodiumWorldRenderer worldRenderer;
    private final int chunkX;
    private final int chunkY;
    private final int chunkZ;
    private final T[] graphicsStates;
    private ChunkRenderData data = ChunkRenderData.ABSENT;
    private CompletableFuture<Void> rebuildTask = null;
    private boolean needsRebuild;
    private boolean needsImportantRebuild;
    private Direction direction;
    private int visibleFrame = -1;
    private byte cullingState;
    private long visibilityData;
    private final ChunkRenderContainer<T>[] adjacent;
    private boolean tickable;

    public ChunkRenderContainer(ChunkRenderBackend<T> backend, SodiumWorldRenderer worldRenderer, int chunkX, int chunkY, int chunkZ) {
        this.worldRenderer = worldRenderer;
        this.chunkX = chunkX;
        this.chunkY = chunkY;
        this.chunkZ = chunkZ;
        this.adjacent = new ChunkRenderContainer[DirectionUtil.DIRECTION_COUNT];
        this.graphicsStates = (ChunkGraphicsState[])Array.newInstance(backend.getGraphicsStateType(), backend.getRenderPassManager().getPassCount());
    }

    public void cancelRebuildTask() {
        this.needsRebuild = false;
        this.needsImportantRebuild = false;
        if (this.rebuildTask != null) {
            this.rebuildTask.cancel(false);
            this.rebuildTask = null;
        }
    }

    public ChunkRenderData getData() {
        return this.data;
    }

    public boolean needsRebuild() {
        return this.needsRebuild;
    }

    public boolean needsImportantRebuild() {
        return this.needsImportantRebuild;
    }

    public boolean isVisibleThrough(Direction from, Direction to) {
        return (this.visibilityData & 1L << (from.ordinal() << 3) + to.ordinal()) != 0L;
    }

    public void delete() {
        this.cancelRebuildTask();
        this.setData(ChunkRenderData.ABSENT);
        this.deleteGraphicsState();
    }

    private void deleteGraphicsState() {
        T[] states = this.graphicsStates;
        for (int i = 0; i < states.length; ++i) {
            T state = states[i];
            if (state == null) continue;
            ((ChunkGraphicsState)state).delete();
            states[i] = null;
        }
    }

    public void setData(ChunkRenderData info) {
        if (info == null) {
            throw new NullPointerException("Mesh information must not be null");
        }
        this.visibilityData = 0L;
        for (Direction from : DirectionUtil.ALL_DIRECTIONS) {
            for (Direction to : DirectionUtil.ALL_DIRECTIONS) {
                if (!info.isVisibleThrough(from, to)) continue;
                this.visibilityData |= 1L << (from.ordinal() << 3) + to.ordinal();
            }
        }
        this.worldRenderer.onChunkRenderUpdated(this.data, info);
        this.data = info;
        this.tickable = !info.getAnimatedSprites().isEmpty();
    }

    public boolean scheduleRebuild(boolean important) {
        boolean changed = !this.needsRebuild || !this.needsImportantRebuild && important;
        this.needsImportantRebuild = important;
        this.needsRebuild = true;
        return changed;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void setCullingState(byte parent, Direction dir) {
        this.cullingState = (byte)(parent | 1 << dir.ordinal());
    }

    public boolean canCull(Direction dir) {
        return (this.cullingState & 1 << dir.ordinal()) != 0;
    }

    public void resetGraphState() {
        this.direction = null;
        this.cullingState = 0;
    }

    public void setDirection(Direction dir) {
        this.direction = dir;
    }

    public void setVisibleFrame(int frame) {
        this.visibleFrame = frame;
    }

    public int getLastVisibleFrame() {
        return this.visibleFrame;
    }

    public SectionPos getChunkPos() {
        return SectionPos.func_218154_a((int)this.chunkX, (int)this.chunkY, (int)this.chunkZ);
    }

    public boolean isOutsideFrustum(FrustumExtended frustum) {
        float z;
        float y;
        float x = this.getOriginX();
        return !frustum.fastAabbTest(x, y = (float)this.getOriginY(), z = (float)this.getOriginZ(), x + 16.0f, y + 16.0f, z + 16.0f);
    }

    public void tick() {
        for (TextureAtlasSprite TextureAtlasSprite2 : this.data.getAnimatedSprites()) {
            SpriteUtil.markSpriteActive(TextureAtlasSprite2);
        }
    }

    public int getOriginX() {
        return this.chunkX << 4;
    }

    public int getOriginY() {
        return this.chunkY << 4;
    }

    public int getOriginZ() {
        return this.chunkZ << 4;
    }

    public int getRenderX() {
        return this.getOriginX() - 8;
    }

    public int getRenderY() {
        return this.getOriginY() - 8;
    }

    public int getRenderZ() {
        return this.getOriginZ() - 8;
    }

    public double getSquaredDistance(BlockPos pos) {
        return this.getSquaredDistance((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public double getSquaredDistance(double x, double y, double z) {
        double xDist = x - this.getCenterX();
        double yDist = y - this.getCenterY();
        double zDist = z - this.getCenterZ();
        return xDist * xDist + yDist * yDist + zDist * zDist;
    }

    private double getCenterX() {
        return (double)this.getOriginX() + 8.0;
    }

    private double getCenterY() {
        return (double)this.getOriginY() + 8.0;
    }

    private double getCenterZ() {
        return (double)this.getOriginZ() + 8.0;
    }

    public byte getCullingState() {
        return this.cullingState;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public BlockPos getRenderOrigin() {
        return new BlockPos(this.getRenderX(), this.getRenderY(), this.getRenderZ());
    }

    public T[] getGraphicsStates() {
        return this.graphicsStates;
    }

    public void setGraphicsState(BlockRenderPass pass, T state) {
        this.graphicsStates[pass.ordinal()] = state;
    }

    public boolean canRebuild() {
        for (Direction dir : DirectionUtil.HORIZONTAL_DIRECTIONS) {
            Direction corner;
            ChunkRenderContainer<T> adj = this.adjacent[dir.ordinal()];
            if (adj == null) {
                return false;
            }
            if (dir == Direction.NORTH) {
                corner = Direction.EAST;
            } else if (dir == Direction.SOUTH) {
                corner = Direction.WEST;
            } else if (dir == Direction.WEST) {
                corner = Direction.NORTH;
            } else {
                if (dir != Direction.EAST) continue;
                corner = Direction.SOUTH;
            }
            if (adj.getAdjacentRender(corner) != null) continue;
            return false;
        }
        return true;
    }

    public double getSquaredDistanceXZ(double x, double z) {
        double xDist = x - this.getCenterX();
        double zDist = z - this.getCenterZ();
        return xDist * xDist + zDist * zDist;
    }

    public void setAdjacentRender(Direction dir, ChunkRenderContainer<T> adj) {
        this.adjacent[dir.ordinal()] = adj;
    }

    public ChunkRenderContainer<T> getAdjacentRender(Direction dir) {
        return this.adjacent[dir.ordinal()];
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkY() {
        return this.chunkY;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public ChunkRenderBounds getBounds() {
        return this.data.getBounds();
    }

    public T getGraphicsState(BlockRenderPass pass) {
        return this.graphicsStates[pass.ordinal()];
    }

    public boolean isTickable() {
        return this.tickable;
    }

    public int getFacesWithData() {
        return this.data.getFacesWithData();
    }
}

