/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.quad.sink;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadViewMutable;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.sink.ModelQuadSink;
import me.jellysquid.mods.sodium.client.model.quad.sink.ModelQuadSinkDelegate;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.color.ColorU8;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;

public class FallbackQuadSink
implements ModelQuadSink,
ModelQuadSinkDelegate {
    private final IVertexBuilder consumer;
    private final Matrix4f modelMatrix;
    private final Matrix3f normalMatrix;
    private final Vector4f vector;
    private final Vector3f normal;

    public FallbackQuadSink(IVertexBuilder consumer, MatrixStack matrixStack) {
        this.consumer = consumer;
        this.modelMatrix = matrixStack.func_227866_c_().func_227870_a_();
        this.normalMatrix = matrixStack.func_227866_c_().func_227872_b_();
        this.vector = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.normal = new Vector3f(0.0f, 0.0f, 0.0f);
    }

    @Override
    public void write(ModelQuadViewMutable quad) {
        Vector4f posVec = this.vector;
        Vector3f normVec = this.normal;
        for (int i = 0; i < 4; ++i) {
            float x = quad.getX(i);
            float y = quad.getY(i);
            float z = quad.getZ(i);
            posVec.func_195911_a(x, y, z, 1.0f);
            posVec.func_229372_a_(this.modelMatrix);
            int color = quad.getColor(i);
            float r = ColorU8.normalize(ColorABGR.unpackRed(color));
            float g = ColorU8.normalize(ColorABGR.unpackGreen(color));
            float b = ColorU8.normalize(ColorABGR.unpackBlue(color));
            float a = ColorU8.normalize(ColorABGR.unpackAlpha(color));
            float u = quad.getTexU(i);
            float v = quad.getTexV(i);
            int light = quad.getLight(i);
            int norm = quad.getNormal(i);
            float normX = Norm3b.unpackX(norm);
            float normY = Norm3b.unpackY(norm);
            float normZ = Norm3b.unpackZ(norm);
            normVec.func_195905_a(normX, normY, normZ);
            normVec.func_229188_a_(this.normalMatrix);
            this.consumer.func_225588_a_(posVec.func_195910_a(), posVec.func_195913_b(), posVec.func_195914_c(), r, g, b, a, u, v, OverlayTexture.field_229196_a_, light, normVec.func_195899_a(), normVec.func_195900_b(), normVec.func_195902_c());
        }
    }

    @Override
    public ModelQuadSink get(ModelQuadFacing facing) {
        return this;
    }
}

