/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui.options.control;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.Validate;

public class SliderControl
implements Control<Integer> {
    private final Option<Integer> option;
    private final int min;
    private final int max;
    private final int interval;
    private final ControlValueFormatter mode;

    public SliderControl(Option<Integer> option, int min, int max, int interval, ControlValueFormatter mode) {
        Validate.isTrue((max > min ? 1 : 0) != 0, (String)"The maximum value must be greater than the minimum value", (Object[])new Object[0]);
        Validate.isTrue((interval > 0 ? 1 : 0) != 0, (String)"The slider interval must be greater than zero", (Object[])new Object[0]);
        Validate.isTrue(((max - min) % interval == 0 ? 1 : 0) != 0, (String)"The maximum value must be divisable by the interval", (Object[])new Object[0]);
        Validate.notNull((Object)mode, (String)"The slider mode must not be null", (Object[])new Object[0]);
        this.option = option;
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.mode = mode;
    }

    @Override
    public ControlElement<Integer> createElement(Dim2i dim) {
        return new Button(this.option, dim, this.min, this.max, this.interval, this.mode);
    }

    @Override
    public Option<Integer> getOption() {
        return this.option;
    }

    @Override
    public int getMaxWidth() {
        return 130;
    }

    private static class Button
    extends ControlElement<Integer> {
        private static final int THUMB_WIDTH = 2;
        private static final int TRACK_HEIGHT = 1;
        private final Rectangle2d sliderBounds;
        private final ControlValueFormatter formatter;
        private final int min;
        private final int range;
        private final int interval;
        private double thumbPosition;

        public Button(Option<Integer> option, Dim2i dim, int min, int max, int interval, ControlValueFormatter formatter) {
            super(option, dim);
            this.min = min;
            this.range = max - min;
            this.interval = interval;
            this.thumbPosition = this.getThumbPositionForValue(option.getValue());
            this.formatter = formatter;
            this.sliderBounds = new Rectangle2d(dim.getLimitX() - 96, dim.getCenterY() - 5, 90, 10);
        }

        @Override
        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float delta) {
            super.func_230430_a_(matrixStack, mouseX, mouseY, delta);
            if (this.option.isAvailable() && this.hovered) {
                this.renderSlider(matrixStack);
            } else {
                this.renderStandaloneValue(matrixStack);
            }
        }

        private void renderStandaloneValue(MatrixStack matrixStack) {
            int sliderX = this.sliderBounds.func_199318_a();
            int sliderY = this.sliderBounds.func_199319_b();
            int sliderWidth = this.sliderBounds.func_199316_c();
            int sliderHeight = this.sliderBounds.func_199317_d();
            String label = this.formatter.format((Integer)this.option.getValue());
            int labelWidth = this.font.func_78256_a(label);
            this.drawString(matrixStack, label, sliderX + sliderWidth - labelWidth, sliderY + sliderHeight / 2 - 4, -1);
        }

        private void renderSlider(MatrixStack matrixStack) {
            int sliderX = this.sliderBounds.func_199318_a();
            int sliderY = this.sliderBounds.func_199319_b();
            int sliderWidth = this.sliderBounds.func_199316_c();
            int sliderHeight = this.sliderBounds.func_199317_d();
            int thumbOffset = (int)Math.floor((double)(this.getIntValue() - this.min) / (double)this.range * (double)sliderWidth);
            int thumbX = sliderX + thumbOffset - 2;
            int trackY = sliderY + sliderHeight / 2 - 1;
            this.drawRect(thumbX, sliderY, thumbX + 4, sliderY + sliderHeight, -1);
            this.drawRect(sliderX, trackY, sliderX + sliderWidth, trackY + 1, -1);
            String label = String.valueOf(this.getIntValue());
            int labelWidth = this.font.func_78256_a(label);
            this.drawString(matrixStack, label, sliderX - labelWidth - 6, sliderY + sliderHeight / 2 - 4, -1);
        }

        public int getIntValue() {
            return this.min + this.interval * (int)Math.round(this.getSnappedThumbPosition() / (double)this.interval);
        }

        public double getSnappedThumbPosition() {
            return this.thumbPosition / (1.0 / (double)this.range);
        }

        public double getThumbPositionForValue(int value) {
            return (double)(value - this.min) * (1.0 / (double)this.range);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (this.option.isAvailable() && button == 0 && this.sliderBounds.func_199315_b((int)mouseX, (int)mouseY)) {
                this.setValueFromMouse(mouseX);
                return true;
            }
            return false;
        }

        private void setValueFromMouse(double d) {
            this.setValue((d - (double)(this.sliderBounds.func_199318_a() + 4)) / (double)(this.sliderBounds.func_199316_c() - 8));
        }

        private void setValue(double d) {
            this.thumbPosition = MathHelper.func_151237_a((double)d, (double)0.0, (double)1.0);
            int value = this.getIntValue();
            if ((Integer)this.option.getValue() != value) {
                this.option.setValue(value);
            }
        }

        public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.option.isAvailable() && button == 0) {
                this.setValueFromMouse(mouseX);
                return true;
            }
            return false;
        }
    }
}

