/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui.options;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.binding.GenericBinding;
import me.jellysquid.mods.sodium.client.gui.options.binding.OptionBinding;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.Validate;

public class OptionImpl<S, T>
implements Option<T> {
    private final OptionStorage<S> storage;
    private final OptionBinding<S, T> binding;
    private final Control<T> control;
    private final EnumSet<OptionFlag> flags;
    private final String name;
    private final ITextComponent tooltip;
    private final OptionImpact impact;
    private T value;
    private T modifiedValue;
    private final boolean enabled;

    private OptionImpl(OptionStorage<S> storage, String name, String tooltip, OptionBinding<S, T> binding, Function<OptionImpl<S, T>, Control<T>> control, EnumSet<OptionFlag> flags, OptionImpact impact, boolean enabled) {
        this.storage = storage;
        this.name = name;
        this.tooltip = new StringTextComponent(tooltip);
        this.binding = binding;
        this.impact = impact;
        this.flags = flags;
        this.control = control.apply(this);
        this.enabled = enabled;
        this.reset();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ITextComponent getTooltip() {
        return this.tooltip;
    }

    @Override
    public OptionImpact getImpact() {
        return this.impact;
    }

    @Override
    public Control<T> getControl() {
        return this.control;
    }

    @Override
    public T getValue() {
        return this.modifiedValue;
    }

    @Override
    public void setValue(T value) {
        this.modifiedValue = value;
    }

    @Override
    public void reset() {
        this.value = this.binding.getValue(this.storage.getData());
        this.modifiedValue = this.value;
    }

    @Override
    public OptionStorage<?> getStorage() {
        return this.storage;
    }

    @Override
    public boolean isAvailable() {
        return this.enabled;
    }

    @Override
    public boolean hasChanged() {
        return this.value != this.modifiedValue;
    }

    @Override
    public void applyChanges() {
        this.binding.setValue(this.storage.getData(), this.modifiedValue);
        this.value = this.modifiedValue;
    }

    @Override
    public Collection<OptionFlag> getFlags() {
        return this.flags;
    }

    public static <S, T> Builder<S, T> createBuilder(Class<T> type, OptionStorage<S> storage) {
        return new Builder(storage);
    }

    public static class Builder<S, T> {
        private final OptionStorage<S> storage;
        private String name;
        private String tooltip;
        private OptionBinding<S, T> binding;
        private Function<OptionImpl<S, T>, Control<T>> control;
        private OptionImpact impact;
        private final EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        private boolean enabled = true;

        private Builder(OptionStorage<S> storage) {
            this.storage = storage;
        }

        public Builder<S, T> setName(String name) {
            Validate.notNull((Object)name, (String)"Argument must not be null", (Object[])new Object[0]);
            this.name = name;
            return this;
        }

        public Builder<S, T> setTooltip(String tooltip) {
            Validate.notNull((Object)tooltip, (String)"Argument must not be null", (Object[])new Object[0]);
            this.tooltip = tooltip;
            return this;
        }

        public Builder<S, T> setBinding(BiConsumer<S, T> setter, Function<S, T> getter) {
            Validate.notNull(setter, (String)"Setter must not be null", (Object[])new Object[0]);
            Validate.notNull(getter, (String)"Getter must not be null", (Object[])new Object[0]);
            this.binding = new GenericBinding<S, T>(setter, getter);
            return this;
        }

        public Builder<S, T> setBinding(OptionBinding<S, T> binding) {
            Validate.notNull(binding, (String)"Argument must not be null", (Object[])new Object[0]);
            this.binding = binding;
            return this;
        }

        public Builder<S, T> setControl(Function<OptionImpl<S, T>, Control<T>> control) {
            Validate.notNull(control, (String)"Argument must not be null", (Object[])new Object[0]);
            this.control = control;
            return this;
        }

        public Builder<S, T> setImpact(OptionImpact impact) {
            this.impact = impact;
            return this;
        }

        public Builder<S, T> setEnabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public Builder<S, T> setFlags(OptionFlag ... flags) {
            Collections.addAll(this.flags, flags);
            return this;
        }

        public OptionImpl<S, T> build() {
            Validate.notNull((Object)this.name, (String)"Name must be specified", (Object[])new Object[0]);
            Validate.notNull((Object)this.tooltip, (String)"Tooltip must be specified", (Object[])new Object[0]);
            Validate.notNull(this.binding, (String)"Option binding must be specified", (Object[])new Object[0]);
            Validate.notNull(this.control, (String)"Control must be specified", (Object[])new Object[0]);
            return new OptionImpl(this.storage, this.name, this.tooltip, this.binding, this.control, this.flags, this.impact, this.enabled);
        }
    }
}

