/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptionPages;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.VideoSettingsScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class SodiumOptionsGUI
extends Screen {
    private final List<OptionPage> pages = new ArrayList<OptionPage>();
    private final List<ControlElement<?>> controls = new ArrayList();
    private final List<IRenderable> IRenderable = new ArrayList<IRenderable>();
    private final Screen prevScreen;
    private OptionPage currentPage;
    private FlatButtonWidget applyButton;
    private FlatButtonWidget closeButton;
    private FlatButtonWidget undoButton;
    private boolean hasPendingChanges;
    private ControlElement<?> hoveredElement;

    public SodiumOptionsGUI(Screen prevScreen) {
        super((ITextComponent)new TranslationTextComponent("Sodium Options"));
        this.prevScreen = prevScreen;
        this.pages.add(SodiumGameOptionPages.general());
        this.pages.add(SodiumGameOptionPages.quality());
        this.pages.add(SodiumGameOptionPages.advanced());
    }

    public void setPage(OptionPage page) {
        this.currentPage = page;
        this.rebuildGUI();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.rebuildGUI();
    }

    private void rebuildGUI() {
        this.controls.clear();
        this.field_230705_e_.clear();
        this.IRenderable.clear();
        if (this.currentPage == null) {
            if (this.pages.isEmpty()) {
                throw new IllegalStateException("No pages are available?!");
            }
            this.currentPage = this.pages.get(0);
        }
        this.rebuildGUIPages();
        this.rebuildGUIOptions();
        this.undoButton = new FlatButtonWidget(new Dim2i(this.field_230708_k_ - 211, this.field_230709_l_ - 30, 65, 20), I18n.func_135052_a((String)"sodium.options.buttons.undo", (Object[])new Object[0]), this::undoChanges);
        this.applyButton = new FlatButtonWidget(new Dim2i(this.field_230708_k_ - 142, this.field_230709_l_ - 30, 65, 20), I18n.func_135052_a((String)"sodium.options.buttons.apply", (Object[])new Object[0]), this::applyChanges);
        this.closeButton = new FlatButtonWidget(new Dim2i(this.field_230708_k_ - 73, this.field_230709_l_ - 30, 65, 20), I18n.func_135052_a((String)"sodium.options.buttons.close", (Object[])new Object[0]), this::func_231175_as__);
        this.field_230705_e_.add(this.undoButton);
        this.field_230705_e_.add(this.applyButton);
        this.field_230705_e_.add(this.closeButton);
        for (IGuiEventListener element : this.field_230705_e_) {
            if (!(element instanceof IRenderable)) continue;
            this.IRenderable.add((IRenderable)element);
        }
    }

    private void rebuildGUIPages() {
        int x = 10;
        int y = 6;
        for (OptionPage page : this.pages) {
            int width = 10 + this.field_230712_o_.func_78256_a(page.getName());
            FlatButtonWidget button = new FlatButtonWidget(new Dim2i(x, y, width, 16), page.getName(), () -> this.setPage(page));
            button.setSelected(this.currentPage == page);
            x += width + 6;
            this.field_230705_e_.add(button);
        }
    }

    private void rebuildGUIOptions() {
        int x = 10;
        int y = 28;
        for (OptionGroup group : this.currentPage.getGroups()) {
            for (Option option : group.getOptions()) {
                Control control = option.getControl();
                ControlElement element = control.createElement(new Dim2i(x, y, 200, 18));
                this.controls.add(element);
                this.field_230705_e_.add(element);
                y += 18;
            }
            y += 4;
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float delta) {
        super.func_230446_a_(matrixStack);
        this.updateControls();
        for (IRenderable IRenderable2 : this.IRenderable) {
            IRenderable2.func_230430_a_(matrixStack, mouseX, mouseY, delta);
        }
        if (this.hoveredElement != null) {
            this.renderOptionTooltip(matrixStack, this.hoveredElement);
        }
    }

    private void updateControls() {
        ControlElement hovered = this.getActiveControls().filter(ControlElement::isHovered).findFirst().orElse(null);
        boolean hasChanges = this.getAllOptions().anyMatch(Option::hasChanged);
        for (OptionPage page : this.pages) {
            for (Option option : page.getOptions()) {
                if (!option.hasChanged()) continue;
                hasChanges = true;
            }
        }
        this.applyButton.setEnabled(hasChanges);
        this.undoButton.setVisible(hasChanges);
        this.closeButton.setEnabled(!hasChanges);
        this.hasPendingChanges = hasChanges;
        this.hoveredElement = hovered;
    }

    private Stream<Option<?>> getAllOptions() {
        return this.pages.stream().flatMap(s -> s.getOptions().stream());
    }

    private Stream<ControlElement<?>> getActiveControls() {
        return this.controls.stream();
    }

    private void renderOptionTooltip(MatrixStack matrixStack, ControlElement<?> element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        Dim2i dim = element.getDimensions();
        int textPadding = 3;
        int boxPadding = 3;
        int boxWidth = 200;
        int textWidth = boxWidth - textPadding * 2;
        int boxY = dim.getOriginY();
        int boxX = dim.getLimitX() + boxPadding;
        Option<?> option = element.getOption();
        IFormattableTextComponent title = new StringTextComponent(option.getName()).func_240699_a_(TextFormatting.GRAY);
        ArrayList<IReorderingProcessor> tooltip = new ArrayList<IReorderingProcessor>(this.field_230712_o_.func_238425_b_((ITextProperties)option.getTooltip(), boxWidth - textPadding * 2));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            tooltip.add(LanguageMap.func_74808_a().func_241870_a((ITextProperties)new StringTextComponent(TextFormatting.GRAY + "Performance Impact: " + impact.toDisplayString())));
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + boxPadding)) > (boxYCutoff = this.field_230709_l_ - 40)) {
            boxY -= boxYLimit - boxYCutoff;
        }
        this.func_238468_a_(matrixStack, boxX, boxY, boxX + boxWidth, boxY + boxHeight, -536870912, -536870912);
        for (int i = 0; i < tooltip.size(); ++i) {
            this.field_230712_o_.func_238422_b_(matrixStack, (IReorderingProcessor)tooltip.get(i), (float)(boxX + textPadding), (float)(boxY + textPadding + i * 12), -1);
        }
    }

    private void applyChanges() {
        HashSet dirtyStorages = new HashSet();
        EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        this.getAllOptions().forEach(option -> {
            if (!option.hasChanged()) {
                return;
            }
            option.applyChanges();
            flags.addAll(option.getFlags());
            dirtyStorages.add(option.getStorage());
        });
        Minecraft client = Minecraft.func_71410_x();
        if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_RELOAD)) {
            client.field_71438_f.func_72712_a();
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_ASSET_RELOAD)) {
            client.func_228020_b_(client.field_71474_y.field_151442_I);
            client.func_213245_w();
        }
        for (OptionStorage storage : dirtyStorages) {
            storage.save();
        }
    }

    private void undoChanges() {
        this.getAllOptions().forEach(Option::reset);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 80 && (modifiers & 1) != 0) {
            Minecraft.func_71410_x().func_147108_a((Screen)new VideoSettingsScreen(this.prevScreen, Minecraft.func_71410_x().field_71474_y));
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231178_ax__() {
        return !this.hasPendingChanges;
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a(this.prevScreen);
    }
}

