/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.binding.compat.VanillaBooleanOptionBinding;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.SliderControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.storage.MinecraftOptionsStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import me.jellysquid.mods.sodium.client.util.UnsafeUtil;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.AttackIndicatorStatus;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.shader.Framebuffer;

public class SodiumGameOptionPages {
    private static final SodiumOptionsStorage sodiumOpts = new SodiumOptionsStorage();
    private static final MinecraftOptionsStorage vanillaOpts = new MinecraftOptionsStorage();

    public static OptionPage general() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.renderDistance", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.view_distance.tooltip", (Object[])new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 2, 32, 1, ControlValueFormatter.quantity("Chunks"))).setBinding((options, value) -> {
            options.field_151451_c = value;
        }, options -> options.field_151451_c).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.gamma", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.brightness.tooltip", (Object[])new Object[0])).setControl(opt -> new SliderControl((Option<Integer>)opt, 0, 100, 1, ControlValueFormatter.brightness())).setBinding((opts, value) -> {
            opts.field_74333_Y = (double)value.intValue() * 0.01;
        }, opts -> (int)(opts.field_74333_Y / 0.01)).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"options.renderClouds", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.clouds.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            Framebuffer framebuffer;
            opts.quality.enableClouds = value;
            if (Minecraft.func_238218_y_() && (framebuffer = Minecraft.func_71410_x().field_71438_f.func_239232_u_()) != null) {
                framebuffer.func_216493_b(Minecraft.field_142025_a);
            }
        }, opts -> opts.quality.enableClouds).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.fog.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.fog.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.quality.enableFog = value;
        }, opts -> opts.quality.enableFog).setImpact(OptionImpact.LOW).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.guiScale", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.gui_scale.tooltip", (Object[])new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 0, 4, 1, ControlValueFormatter.guiScale())).setBinding((opts, value) -> {
            opts.field_74335_Z = value;
            Minecraft client = Minecraft.func_71410_x();
            client.func_213226_a();
        }, opts -> opts.field_74335_Z).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.fullscreen", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.fullscreen.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_74353_u = value;
            Minecraft client = Minecraft.func_71410_x();
            MainWindow window = client.func_228018_at_();
            if (window != null && window.func_198113_j() != opts.field_74353_u) {
                window.func_198077_g();
                opts.field_74353_u = window.func_198113_j();
            }
        }, opts -> opts.field_74353_u).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.vsync", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.v_sync.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding(new VanillaBooleanOptionBinding(AbstractOption.field_216682_F)).setImpact(OptionImpact.VARIES).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.framerateLimit", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.fps_limit.tooltip", (Object[])new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 5, 260, 5, ControlValueFormatter.fpsLimit())).setBinding((opts, value) -> {
            opts.field_74350_i = value;
            Minecraft.func_71410_x().func_228018_at_().func_216526_a(value.intValue());
        }, opts -> opts.field_74350_i).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.viewBobbing", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.view_bobbing.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding(new VanillaBooleanOptionBinding(AbstractOption.field_216692_P)).build()).add(OptionImpl.createBuilder(AttackIndicatorStatus.class, vanillaOpts).setName(I18n.func_135052_a((String)"options.attackIndicator", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.attack_indicator.tooltip", (Object[])new Object[0])).setControl(opts -> new CyclingControl<AttackIndicatorStatus>((Option<AttackIndicatorStatus>)opts, AttackIndicatorStatus.class, new String[]{"Off", "Crosshair", "Hotbar"})).setBinding((opts, value) -> {
            opts.field_186716_M = value;
        }, opts -> opts.field_186716_M).build()).build());
        return new OptionPage(I18n.func_135052_a((String)"stat.generalButton", (Object[])new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage quality() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(GraphicsFanciness.class, vanillaOpts).setName(I18n.func_135052_a((String)"options.graphics", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.graphics_quality.tooltip", (Object[])new Object[0])).setControl(option -> new CyclingControl<GraphicsFanciness>((Option<GraphicsFanciness>)option, GraphicsFanciness.class, new String[]{I18n.func_135052_a((String)"options.graphics.fast", (Object[])new Object[0]), I18n.func_135052_a((String)"options.graphics.fancy", (Object[])new Object[0]), I18n.func_135052_a((String)"options.graphics.fabulous", (Object[])new Object[0])})).setBinding((opts, value) -> {
            opts.field_238330_f_ = value;
        }, opts -> opts.field_238330_f_).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).setImpact(OptionImpact.HIGH).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.clouds_quality.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.clouds_quality.tooltip", (Object[])new Object[0])).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.cloudQuality = value;
        }, opts -> opts.quality.cloudQuality).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.weather_quality.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.weather_quality.tooltip", (Object[])new Object[0])).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.weatherQuality = value;
        }, opts -> opts.quality.weatherQuality).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(ParticleStatus.class, vanillaOpts).setName(I18n.func_135052_a((String)"sodium.options.particle_quality.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.particle_quality.tooltip", (Object[])new Object[0])).setControl(opt -> new CyclingControl<ParticleStatus>((Option<ParticleStatus>)opt, ParticleStatus.class, new String[]{"High", "Medium", "Low"})).setBinding((opts, value) -> {
            opts.field_74362_aa = value;
        }, opts -> opts.field_74362_aa).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(SodiumGameOptions.LightingQuality.class, sodiumOpts).setName(I18n.func_135052_a((String)"options.ao", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.smooth_lighting.tooltip", (Object[])new Object[0])).setControl(option -> new CyclingControl<SodiumGameOptions.LightingQuality>((Option<SodiumGameOptions.LightingQuality>)option, SodiumGameOptions.LightingQuality.class)).setBinding((opts, value) -> {
            opts.quality.smoothLighting = value;
        }, opts -> opts.quality.smoothLighting).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.biomeBlendRadius", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.biome_blend.tooltip", (Object[])new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 0, 7, 1, ControlValueFormatter.quantityOrDisabled("block(s)", "None"))).setBinding((opts, value) -> {
            opts.field_205217_U = value;
        }, opts -> opts.field_205217_U).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.entityDistanceScaling", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.entity_distance.tooltip", (Object[])new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 50, 500, 25, ControlValueFormatter.percentage())).setBinding((opts, value) -> {
            opts.field_238329_c_ = (float)value.intValue() / 100.0f;
        }, opts -> Math.round(opts.field_238329_c_ * 100.0f)).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.entityShadows", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.entity_shadows.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_181151_V = value;
        }, opts -> opts.field_181151_V).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.vignette.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.vignette.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.quality.enableVignette = value;
        }, opts -> opts.quality.enableVignette).setImpact(OptionImpact.LOW).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.mipmapLevels", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.mipmap_levels.tooltip", (Object[])new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 0, 4, 1, ControlValueFormatter.multiplier())).setBinding((opts, value) -> {
            opts.field_151442_I = value;
        }, opts -> opts.field_151442_I).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_ASSET_RELOAD).build()).build());
        return new OptionPage(I18n.func_135052_a((String)"sodium.options.pages.quality", (Object[])new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage advanced() {
        boolean disableBlacklist = SodiumClientMod.options().advanced.disableDriverBlacklist;
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(SodiumGameOptions.ChunkRendererBackendOption.class, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.chunk_renderer.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.chunk_renderer.tooltip", (Object[])new Object[0])).setControl(opt -> new CyclingControl((Option)opt, SodiumGameOptions.ChunkRendererBackendOption.class, (Enum[])SodiumGameOptions.ChunkRendererBackendOption.getAvailableOptions(disableBlacklist))).setBinding((opts, value) -> {
            opts.advanced.chunkRendererBackend = value;
        }, opts -> opts.advanced.chunkRendererBackend).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.use_chunk_face_culling.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.use_chunk_face_culling.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.useChunkFaceCulling = value;
        }, opts -> opts.advanced.useChunkFaceCulling).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.use_compact_vertex_format.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.use_compact_vertex_format.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.useCompactVertexFormat = value;
        }, opts -> opts.advanced.useCompactVertexFormat).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.use_fog_occlusion.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.use_fog_occlusion.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.useFogOcclusion = value;
        }, opts -> opts.advanced.useFogOcclusion).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.use_entity_culling.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.use_entity_culling.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.useAdvancedEntityCulling = value;
        }, opts -> opts.advanced.useAdvancedEntityCulling).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.use_particle_culling.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.use_particle_culling.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.useParticleCulling = value;
        }, opts -> opts.advanced.useParticleCulling).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.animate_only_visible_textures.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.animate_only_visible_textures.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.animateOnlyVisibleTextures = value;
        }, opts -> opts.advanced.animateOnlyVisibleTextures).setImpact(OptionImpact.MEDIUM).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.use_memory_intrinsics.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.use_memory_intrinsics.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setEnabled(UnsafeUtil.isSupported()).setBinding((opts, value) -> {
            opts.advanced.useMemoryIntrinsics = value;
        }, opts -> opts.advanced.useMemoryIntrinsics).setImpact(OptionImpact.MEDIUM).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.disable_driver_blacklist.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.disable_driver_blacklist.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.disableDriverBlacklist = value;
        }, opts -> opts.advanced.disableDriverBlacklist).build()).build());
        return new OptionPage(I18n.func_135052_a((String)"sodium.options.pages.advanced", (Object[])new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }
}

