/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.shader;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.jellysquid.mods.sodium.client.gl.GlObject;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttribute;
import me.jellysquid.mods.sodium.client.gl.shader.GlShader;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL20;

public abstract class GlProgram
extends GlObject {
    private static final Logger LOGGER = LogManager.getLogger(GlProgram.class);
    private final ResourceLocation name;

    protected GlProgram(ResourceLocation name, int program) {
        this.name = name;
        this.setHandle(program);
    }

    public static Builder builder(ResourceLocation ResourceLocation2) {
        return new Builder(ResourceLocation2);
    }

    public void bind(MatrixStack matrixStack) {
        GL20.glUseProgram((int)this.handle());
    }

    public void unbind() {
        GL20.glUseProgram((int)0);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public int getUniformLocation(String name) {
        int index = GL20.glGetUniformLocation((int)this.handle(), (CharSequence)name);
        if (index < 0) {
            throw new NullPointerException("No uniform exists with name: " + name);
        }
        return index;
    }

    protected int getAttributeLocation(String name) {
        int index = GL20.glGetAttribLocation((int)this.handle(), (CharSequence)name);
        if (index < 0) {
            throw new NullPointerException("No attribute exists with name: " + name);
        }
        return index;
    }

    public void delete() {
        GL20.glDeleteProgram((int)this.handle());
        this.invalidateHandle();
    }

    public static interface ProgramFactory<P extends GlProgram> {
        public P create(ResourceLocation var1, int var2);
    }

    public static class Builder {
        private final ResourceLocation name;
        private final int program;

        public Builder(ResourceLocation name) {
            this.name = name;
            this.program = GL20.glCreateProgram();
        }

        public Builder attachShader(GlShader shader) {
            GL20.glAttachShader((int)this.program, (int)shader.handle());
            return this;
        }

        public <P extends GlProgram> P build(ProgramFactory<P> factory) {
            int result;
            GL20.glLinkProgram((int)this.program);
            String log = GL20.glGetProgramInfoLog((int)this.program);
            if (!log.isEmpty()) {
                LOGGER.warn("Program link log for " + this.name + ": " + log);
            }
            if ((result = GL20.glGetProgrami((int)this.program, (int)35714)) != 1) {
                throw new RuntimeException("Shader program linking failed, see log for details");
            }
            return factory.create(this.name, this.program);
        }

        public Builder bindAttribute(String name, GlVertexAttribute attribute) {
            GL20.glBindAttribLocation((int)this.program, (int)attribute.getIndex(), (CharSequence)name);
            return this;
        }
    }
}

