/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.func;

import org.lwjgl.opengl.ARBSamplerObjects;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GLCapabilities;

public enum GlSamplerFunctions {
    CORE{

        @Override
        public int glGenSamplers() {
            return GL33.glGenSamplers();
        }

        @Override
        public void glSamplerParameteri(int handle, int param, int value) {
            GL33.glSamplerParameteri((int)handle, (int)param, (int)value);
        }

        @Override
        public void glDeleteSamplers(int handle) {
            GL33.glDeleteSamplers((int)handle);
        }

        @Override
        public void glBindSampler(int texture, int handle) {
            GL33.glBindSampler((int)texture, (int)handle);
        }
    }
    ,
    ARB{

        @Override
        public int glGenSamplers() {
            return ARBSamplerObjects.glGenSamplers();
        }

        @Override
        public void glSamplerParameteri(int handle, int param, int value) {
            ARBSamplerObjects.glSamplerParameteri((int)handle, (int)param, (int)value);
        }

        @Override
        public void glDeleteSamplers(int handle) {
            ARBSamplerObjects.glDeleteSamplers((int)handle);
        }

        @Override
        public void glBindSampler(int texture, int handle) {
            ARBSamplerObjects.glBindSampler((int)texture, (int)handle);
        }
    }
    ,
    UNSUPPORTED{

        @Override
        public int glGenSamplers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void glSamplerParameteri(int handle, int param, int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void glDeleteSamplers(int handle) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void glBindSampler(int texture, int handle) {
            throw new UnsupportedOperationException();
        }
    };


    public abstract int glGenSamplers();

    public abstract void glSamplerParameteri(int var1, int var2, int var3);

    public abstract void glDeleteSamplers(int var1);

    public abstract void glBindSampler(int var1, int var2);

    static GlSamplerFunctions load(GLCapabilities capabilities) {
        if (capabilities.OpenGL33) {
            return CORE;
        }
        if (capabilities.GL_ARB_sampler_objects) {
            return ARB;
        }
        return UNSUPPORTED;
    }
}

