/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.arena;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Set;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferRegion;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.GlMutableBuffer;
import me.jellysquid.mods.sodium.client.gl.util.MemoryTracker;
import org.lwjgl.opengl.GL33;

public class GlBufferArena {
    private final int resizeIncrement;
    private final MemoryTracker memoryTracker;
    private final Set<GlBufferRegion> freeRegions = new ObjectLinkedOpenHashSet();
    private GlBuffer vertexBuffer;
    private boolean isBufferBound;
    private int position;
    private int capacity;
    private int allocCount;
    private int usedBytes;

    public GlBufferArena(MemoryTracker memoryTracker, int initialSize, int resizeIncrement) {
        this.memoryTracker = memoryTracker;
        this.vertexBuffer = this.createBuffer();
        this.vertexBuffer.bind(36663);
        this.vertexBuffer.allocate(36663, initialSize);
        this.vertexBuffer.unbind(36663);
        this.memoryTracker.onMemoryAllocate(this.vertexBuffer.getSize());
        this.resizeIncrement = resizeIncrement;
        this.capacity = initialSize;
    }

    private void resize(int size) {
        this.memoryTracker.onMemoryRelease(this.vertexBuffer.getSize());
        GlBuffer src = this.vertexBuffer;
        src.unbind(36663);
        GlBuffer dst = this.createBuffer();
        GlBuffer.copy(src, dst, 0, 0, this.capacity, size);
        src.delete();
        dst.bind(36663);
        this.vertexBuffer = dst;
        this.capacity = size;
        this.memoryTracker.onMemoryAllocate(this.vertexBuffer.getSize());
    }

    private GlBuffer createBuffer() {
        return new GlMutableBuffer(35048);
    }

    public void bind() {
        this.vertexBuffer.bind(36663);
        this.isBufferBound = true;
    }

    public void ensureCapacity(int len) {
        if (this.position + len >= this.capacity) {
            this.resize(this.getNextSize(len));
        }
    }

    public GlBufferRegion upload(int readTarget, int offset, int len) {
        this.checkBufferBound();
        this.ensureCapacity(len);
        GlBufferRegion segment = this.alloc(len);
        GL33.glCopyBufferSubData((int)readTarget, (int)36663, (long)offset, (long)segment.getStart(), (long)len);
        return segment;
    }

    public void unbind() {
        this.checkBufferBound();
        this.vertexBuffer.unbind(36663);
        this.isBufferBound = false;
    }

    private int getNextSize(int len) {
        return Math.max(this.capacity + this.resizeIncrement, this.capacity + len);
    }

    public void free(GlBufferRegion segment) {
        if (!this.freeRegions.add(segment)) {
            throw new IllegalArgumentException("Segment already freed");
        }
        this.memoryTracker.onMemoryFree(segment.getLength());
        --this.allocCount;
        this.usedBytes -= segment.getLength();
    }

    private GlBufferRegion alloc(int len) {
        GlBufferRegion segment = this.allocReuse(len);
        if (segment == null) {
            segment = new GlBufferRegion(this, this.position, len);
            this.position += len;
        }
        ++this.allocCount;
        this.usedBytes += segment.getLength();
        this.memoryTracker.onMemoryUse(segment.getLength());
        return segment;
    }

    private GlBufferRegion allocReuse(int len) {
        GlBufferRegion bestSegment = null;
        for (GlBufferRegion segment : this.freeRegions) {
            if (segment.getLength() < len || bestSegment != null && bestSegment.getLength() <= segment.getLength()) continue;
            bestSegment = segment;
        }
        if (bestSegment == null) {
            return null;
        }
        this.freeRegions.remove(bestSegment);
        int excess = bestSegment.getLength() - len;
        if (excess > 0) {
            this.freeRegions.add(new GlBufferRegion(this, bestSegment.getStart() + len, excess));
        }
        return new GlBufferRegion(this, bestSegment.getStart(), len);
    }

    public void delete() {
        this.memoryTracker.onMemoryFree(this.usedBytes);
        this.memoryTracker.onMemoryRelease(this.vertexBuffer.getSize());
        this.vertexBuffer.delete();
    }

    public boolean isEmpty() {
        return this.allocCount <= 0;
    }

    public GlBuffer getBuffer() {
        return this.vertexBuffer;
    }

    private void checkBufferBound() {
        if (!this.isBufferBound) {
            throw new IllegalStateException("Buffer is not bound");
        }
    }
}

