/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttribute;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttributeFormat;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadEncoder;

public class SodiumVertexFormats {
    public static final GlVertexFormat<ChunkMeshAttribute> CHUNK_MESH_FULL = GlVertexAttribute.builder(ChunkMeshAttribute.class, 32).addElement(ChunkMeshAttribute.POSITION, 0, GlVertexAttributeFormat.FLOAT, 4, false).addElement(ChunkMeshAttribute.COLOR, 16, GlVertexAttributeFormat.UNSIGNED_BYTE, 4, true).addElement(ChunkMeshAttribute.TEXTURE, 20, GlVertexAttributeFormat.FLOAT, 2, false).addElement(ChunkMeshAttribute.LIGHT, 28, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, true).build();
    public static final GlVertexFormat<ChunkMeshAttribute> CHUNK_MESH_COMPACT = GlVertexAttribute.builder(ChunkMeshAttribute.class, 20).addElement(ChunkMeshAttribute.POSITION, 0, GlVertexAttributeFormat.UNSIGNED_SHORT, 4, true).addElement(ChunkMeshAttribute.COLOR, 8, GlVertexAttributeFormat.UNSIGNED_BYTE, 4, true).addElement(ChunkMeshAttribute.TEXTURE, 12, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, true).addElement(ChunkMeshAttribute.LIGHT, 16, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, true).build();
    private static final Reference2ObjectMap<GlVertexFormat<?>, ModelQuadEncoder> encoders = new Reference2ObjectOpenHashMap();

    public static void registerEncoder(GlVertexFormat<?> format, ModelQuadEncoder encoder) {
        if (encoders.containsKey(format)) {
            throw new IllegalStateException("Encoder already registered for format: " + format);
        }
        encoders.put(format, (Object)encoder);
    }

    public static ModelQuadEncoder getEncoder(GlVertexFormat<?> format) {
        ModelQuadEncoder encoder = (ModelQuadEncoder)encoders.get(format);
        if (encoder == null) {
            throw new NullPointerException("No encoder exists for format: " + format);
        }
        return encoder;
    }

    private static short denormalizeFloatAsShort(float value) {
        return (short)(value * 65535.0f);
    }

    private static int encodeLightMapTexCoord(int light) {
        int sl = light >> 16 & 0xFF;
        sl = (sl << 8) + 2048;
        int bl = light & 0xFF;
        bl = (bl << 8) + 2048;
        return sl << 16 | bl;
    }

    static {
        SodiumVertexFormats.registerEncoder(CHUNK_MESH_FULL, (quad, buffer, position, mipped) -> {
            for (int i = 0; i < 4; ++i) {
                buffer.putFloat(position, quad.getX(i));
                buffer.putFloat(position + 4, quad.getY(i));
                buffer.putFloat(position + 8, quad.getZ(i));
                buffer.putFloat(position + 12, mipped ? 1.0f : 0.0f);
                buffer.putInt(position + 16, quad.getColor(i));
                buffer.putFloat(position + 20, quad.getTexU(i));
                buffer.putFloat(position + 24, quad.getTexV(i));
                buffer.putInt(position + 28, SodiumVertexFormats.encodeLightMapTexCoord(quad.getLight(i)));
                position += 32;
            }
        });
        SodiumVertexFormats.registerEncoder(CHUNK_MESH_COMPACT, (quad, buffer, position, mipped) -> {
            for (int i = 0; i < 4; ++i) {
                buffer.putShort(position, SodiumVertexFormats.denormalizeFloatAsShort(quad.getX(i)));
                buffer.putShort(position + 2, SodiumVertexFormats.denormalizeFloatAsShort(quad.getY(i)));
                buffer.putShort(position + 4, SodiumVertexFormats.denormalizeFloatAsShort(quad.getZ(i)));
                buffer.putShort(position + 6, (short)(mipped ? 65535 : 0));
                buffer.putInt(position + 8, quad.getColor(i));
                buffer.putShort(position + 12, SodiumVertexFormats.denormalizeFloatAsShort(quad.getTexU(i)));
                buffer.putShort(position + 14, SodiumVertexFormats.denormalizeFloatAsShort(quad.getTexV(i)));
                buffer.putInt(position + 16, SodiumVertexFormats.encodeLightMapTexCoord(quad.getLight(i)));
                position += 20;
            }
        });
    }

    public static enum ChunkMeshAttribute {
        POSITION,
        COLOR,
        TEXTURE,
        LIGHT;

    }
}

