/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.world;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import me.jellysquid.mods.lithium.common.entity.EntityClassGroup;
import me.jellysquid.mods.lithium.common.world.chunk.ClassGroupFilterableList;
import net.minecraft.entity.Entity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IEntityReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;

public class WorldHelper {
    public static final boolean CUSTOM_TYPE_FILTERABLE_LIST_DISABLED = !MixinLoadTest.class.isAssignableFrom(ClassInheritanceMultiMap.class);

    public static List<Entity> getEntitiesWithCollisionBoxForEntity(IEntityReader entityView, AxisAlignedBB box, Entity collidingEntity) {
        if (CUSTOM_TYPE_FILTERABLE_LIST_DISABLED || collidingEntity != null && EntityClassGroup.MINECART_BOAT_LIKE_COLLISION.contains(collidingEntity.getClass()) || !(entityView instanceof World)) {
            return entityView.func_72839_b(collidingEntity, box);
        }
        return WorldHelper.getEntitiesOfClassGroup((World)entityView, collidingEntity, EntityClassGroup.BOAT_SHULKER_LIKE_COLLISION, box, EntityPredicates.field_180132_d);
    }

    public static List<Entity> getEntitiesOfClassGroup(World world, Entity excluded, EntityClassGroup type, AxisAlignedBB box, Predicate<Entity> predicate) {
        world.func_217381_Z().func_230035_c_("getEntities");
        int minChunkX = MathHelper.func_76128_c((double)((box.field_72340_a - 2.0) / 16.0));
        int maxChunkX = MathHelper.func_76143_f((double)((box.field_72336_d + 2.0) / 16.0));
        int minChunkZ = MathHelper.func_76128_c((double)((box.field_72339_c - 2.0) / 16.0));
        int maxChunkZ = MathHelper.func_76143_f((double)((box.field_72334_f + 2.0) / 16.0));
        ArrayList entities = Lists.newArrayList();
        AbstractChunkProvider chunkManager = world.func_72863_F();
        for (int chunkX = minChunkX; chunkX < maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ < maxChunkZ; ++chunkZ) {
                Chunk chunk = chunkManager.func_217205_a(chunkX, chunkZ, false);
                if (chunk == null) continue;
                WorldHelper.getEntitiesOfClassGroup(chunk, excluded, type, box, entities, predicate);
            }
        }
        return entities;
    }

    public static void getEntitiesOfClassGroup(Chunk worldChunk, Entity excluded, EntityClassGroup type, AxisAlignedBB box, List<Entity> out, Predicate<Entity> predicate) {
        ClassInheritanceMultiMap[] entitySections = worldChunk.func_177429_s();
        int minSectionY = MathHelper.func_76128_c((double)((box.field_72338_b - 2.0) / 16.0));
        int maxSectionY = MathHelper.func_76128_c((double)((box.field_72337_e + 2.0) / 16.0));
        minSectionY = MathHelper.func_76125_a((int)minSectionY, (int)0, (int)(entitySections.length - 1));
        maxSectionY = MathHelper.func_76125_a((int)maxSectionY, (int)0, (int)(entitySections.length - 1));
        for (int sectionY = minSectionY; sectionY <= maxSectionY; ++sectionY) {
            for (Object entity : ((ClassGroupFilterableList)entitySections[sectionY]).getAllOfGroupType(type)) {
                if (entity == excluded || !((Entity)entity).func_174813_aQ().func_72326_a(box) || predicate != null && !predicate.test((Entity)entity)) continue;
                out.add((Entity)entity);
            }
        }
    }

    public static List<Entity> getEntitiesOfClass(World world, Entity except, Class<? extends Entity> entityClass, AxisAlignedBB box) {
        world.func_217381_Z().func_230035_c_("getEntities");
        int minChunkX = MathHelper.func_76128_c((double)((box.field_72340_a - 2.0) / 16.0));
        int maxChunkX = MathHelper.func_76143_f((double)((box.field_72336_d + 2.0) / 16.0));
        int minChunkZ = MathHelper.func_76128_c((double)((box.field_72339_c - 2.0) / 16.0));
        int maxChunkZ = MathHelper.func_76143_f((double)((box.field_72334_f + 2.0) / 16.0));
        ArrayList entities = Lists.newArrayList();
        AbstractChunkProvider chunkManager = world.func_72863_F();
        for (int chunkX = minChunkX; chunkX < maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ < maxChunkZ; ++chunkZ) {
                Chunk chunk = chunkManager.func_217205_a(chunkX, chunkZ, false);
                if (chunk == null) continue;
                WorldHelper.getEntitiesOfClass(chunk, except, entityClass, box, entities);
            }
        }
        return entities;
    }

    private static void getEntitiesOfClass(Chunk worldChunk, Entity excluded, Class<? extends Entity> entityClass, AxisAlignedBB box, List<Entity> out) {
        ClassInheritanceMultiMap[] entitySections = worldChunk.func_177429_s();
        int minChunkY = MathHelper.func_76128_c((double)((box.field_72338_b - 2.0) / 16.0));
        int maxChunkY = MathHelper.func_76128_c((double)((box.field_72337_e + 2.0) / 16.0));
        minChunkY = MathHelper.func_76125_a((int)minChunkY, (int)0, (int)(entitySections.length - 1));
        maxChunkY = MathHelper.func_76125_a((int)maxChunkY, (int)0, (int)(entitySections.length - 1));
        for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
            for (Entity entity : entitySections[chunkY].func_219790_a(entityClass)) {
                if (entity == excluded || !entity.func_174813_aQ().func_72326_a(box)) continue;
                out.add(entity);
            }
        }
    }

    public static boolean areNeighborsWithinSameChunk(BlockPos pos) {
        int localX = pos.func_177958_n() & 0xF;
        int localY = pos.func_177956_o() & 0xF;
        int localZ = pos.func_177952_p() & 0xF;
        return localX > 0 && localY > 0 && localZ > 0 && localX < 15 && localY < 15 && localZ < 15;
    }

    public static boolean areAllNeighborsOutOfBounds(BlockPos pos) {
        return pos.func_177956_o() < -1 || pos.func_177956_o() > 256;
    }

    public static interface MixinLoadTest {
    }
}

