/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.util.collections;

import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class BlockEntityList
implements List<TileEntity> {
    private final ReferenceLinkedOpenHashSet<TileEntity> allBlockEntities;
    private final Long2ReferenceOpenHashMap<TileEntity> posMap;
    private final Long2ReferenceOpenHashMap<List<TileEntity>> posMapMulti;

    public BlockEntityList(List<TileEntity> list, boolean hasPositionLookup) {
        this.posMap = hasPositionLookup ? new Long2ReferenceOpenHashMap() : null;
        Long2ReferenceOpenHashMap long2ReferenceOpenHashMap = this.posMapMulti = hasPositionLookup ? new Long2ReferenceOpenHashMap() : null;
        if (this.posMap != null) {
            this.posMap.defaultReturnValue(null);
            this.posMapMulti.defaultReturnValue(null);
        }
        this.allBlockEntities = new ReferenceLinkedOpenHashSet();
        this.addAll((Collection<? extends TileEntity>)list);
    }

    @Override
    public int size() {
        return this.allBlockEntities.size();
    }

    @Override
    public boolean isEmpty() {
        return this.allBlockEntities.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.allBlockEntities.contains(o);
    }

    @Override
    public Iterator<TileEntity> iterator() {
        return this.allBlockEntities.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.allBlockEntities.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.allBlockEntities.toArray((Object[])a);
    }

    @Override
    public boolean add(TileEntity blockEntity) {
        return this.addNoDoubleAdd(blockEntity, true);
    }

    private boolean addNoDoubleAdd(TileEntity blockEntity, boolean exceptionOnDoubleAdd) {
        long pos;
        TileEntity prev;
        boolean added = this.allBlockEntities.add((Object)blockEntity);
        if (!added && exceptionOnDoubleAdd) {
            this.throwException(blockEntity);
        }
        if (added && this.posMap != null && (prev = (TileEntity)this.posMap.putIfAbsent(pos = BlockEntityList.getEntityPos(blockEntity), (Object)blockEntity)) != null) {
            List multiEntry = (List)this.posMapMulti.computeIfAbsent(pos, l -> new ArrayList());
            if (multiEntry.size() == 0) {
                multiEntry.add(prev);
            }
            multiEntry.add(blockEntity);
        }
        return added;
    }

    private void throwException(TileEntity blockEntity) {
        throw new IllegalStateException("Lithium TileEntityList" + (this.posMap != null ? " with posMap" : "") + ": Adding the same TileEntity object twice: " + blockEntity.func_189515_b(new CompoundNBT()));
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof TileEntity) {
            TileEntity blockEntity = (TileEntity)o;
            if (this.allBlockEntities.remove(o)) {
                if (this.posMap != null) {
                    long pos = BlockEntityList.getEntityPos(blockEntity);
                    List multiEntry = (List)this.posMapMulti.get(pos);
                    if (multiEntry != null) {
                        multiEntry.remove(blockEntity);
                        if (multiEntry.size() <= 1) {
                            this.posMapMulti.remove(pos);
                        }
                    }
                    if (multiEntry != null && multiEntry.size() > 0) {
                        this.posMap.put(pos, multiEntry.get(0));
                    } else {
                        this.posMap.remove(pos);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.allBlockEntities.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends TileEntity> c) {
        for (TileEntity tileEntity : c) {
            this.add(tileEntity);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends TileEntity> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object obj : c) {
            modified |= this.remove(obj);
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        for (TileEntity blockEntity : this.allBlockEntities) {
            if (c.contains(blockEntity)) continue;
            modified |= this.remove(blockEntity);
        }
        return modified;
    }

    @Override
    public void clear() {
        this.allBlockEntities.clear();
        if (this.posMap != null) {
            this.posMap.clear();
            this.posMapMulti.clear();
        }
    }

    @Override
    public TileEntity get(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TileEntity set(int index, TileEntity element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, TileEntity element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TileEntity remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<TileEntity> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<TileEntity> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<TileEntity> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    private static long getEntityPos(TileEntity e) {
        return e.func_174877_v().func_218275_a();
    }

    public boolean addIfAbsent(TileEntity blockEntity) {
        return this.addNoDoubleAdd(blockEntity, false);
    }

    public boolean hasPositionLookup() {
        return this.posMap != null;
    }

    public void markRemovedAndRemoveAllAtPosition(BlockPos blockPos) {
        long pos = blockPos.func_218275_a();
        TileEntity blockEntity = (TileEntity)this.posMap.remove(pos);
        if (blockEntity != null) {
            List multiEntry = (List)this.posMapMulti.remove(pos);
            if (multiEntry != null) {
                for (TileEntity blockEntity1 : multiEntry) {
                    blockEntity1.func_145843_s();
                    this.allBlockEntities.remove((Object)blockEntity1);
                }
            } else {
                blockEntity.func_145843_s();
                this.allBlockEntities.remove((Object)blockEntity);
            }
        }
    }

    public TileEntity getFirstNonRemovedBlockEntityAtPosition(long pos) {
        if (this.isEmpty()) {
            return null;
        }
        TileEntity blockEntity = (TileEntity)this.posMap.get(pos);
        if (blockEntity == null || !blockEntity.func_145837_r()) {
            return blockEntity;
        }
        List multiEntry = (List)this.posMapMulti.get(pos);
        if (multiEntry != null) {
            for (TileEntity blockEntity1 : multiEntry) {
                if (blockEntity1.func_145837_r()) continue;
                return blockEntity1;
            }
        }
        return null;
    }
}

