/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.shapes;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.List;
import me.jellysquid.mods.lithium.common.shapes.VoxelShapeCaster;
import net.minecraft.util.AxisRotation;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapes;

public class VoxelShapeSimpleCube
extends VoxelShape
implements VoxelShapeCaster {
    static final double EPSILON = 1.0E-7;
    final double minX;
    final double minY;
    final double minZ;
    final double maxX;
    final double maxY;
    final double maxZ;
    public final boolean isTiny;

    public VoxelShapeSimpleCube(VoxelShapePart voxels, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        super(voxels);
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.isTiny = this.minX + 3.0E-7 >= this.maxX || this.minY + 3.0E-7 >= this.maxY || this.minZ + 3.0E-7 >= this.maxZ;
    }

    public VoxelShape func_197751_a(double x, double y, double z) {
        return new VoxelShapeSimpleCube(this.field_197768_g, this.minX + x, this.minY + y, this.minZ + z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public double func_212431_a(AxisRotation cycleDirection, AxisAlignedBB box, double maxDist) {
        if (Math.abs(maxDist) < 1.0E-7) {
            return 0.0;
        }
        double penetration = this.calculatePenetration(cycleDirection, box, maxDist);
        if (penetration != maxDist && this.intersects(cycleDirection, box)) {
            return penetration;
        }
        return maxDist;
    }

    private double calculatePenetration(AxisRotation dir, AxisAlignedBB box, double maxDist) {
        switch (dir) {
            case NONE: {
                return VoxelShapeSimpleCube.calculatePenetration(this.minX, this.maxX, box.field_72340_a, box.field_72336_d, maxDist);
            }
            case FORWARD: {
                return VoxelShapeSimpleCube.calculatePenetration(this.minZ, this.maxZ, box.field_72339_c, box.field_72334_f, maxDist);
            }
            case BACKWARD: {
                return VoxelShapeSimpleCube.calculatePenetration(this.minY, this.maxY, box.field_72338_b, box.field_72337_e, maxDist);
            }
        }
        throw new IllegalArgumentException();
    }

    boolean intersects(AxisRotation dir, AxisAlignedBB box) {
        switch (dir) {
            case NONE: {
                return VoxelShapeSimpleCube.lessThan(this.minY, box.field_72337_e) && VoxelShapeSimpleCube.lessThan(box.field_72338_b, this.maxY) && VoxelShapeSimpleCube.lessThan(this.minZ, box.field_72334_f) && VoxelShapeSimpleCube.lessThan(box.field_72339_c, this.maxZ);
            }
            case FORWARD: {
                return VoxelShapeSimpleCube.lessThan(this.minX, box.field_72336_d) && VoxelShapeSimpleCube.lessThan(box.field_72340_a, this.maxX) && VoxelShapeSimpleCube.lessThan(this.minY, box.field_72337_e) && VoxelShapeSimpleCube.lessThan(box.field_72338_b, this.maxY);
            }
            case BACKWARD: {
                return VoxelShapeSimpleCube.lessThan(this.minZ, box.field_72334_f) && VoxelShapeSimpleCube.lessThan(box.field_72339_c, this.maxZ) && VoxelShapeSimpleCube.lessThan(this.minX, box.field_72336_d) && VoxelShapeSimpleCube.lessThan(box.field_72340_a, this.maxX);
            }
        }
        throw new IllegalArgumentException();
    }

    private static double calculatePenetration(double a1, double a2, double b1, double b2, double maxDist) {
        double penetration;
        if (maxDist > 0.0 ? (penetration = a1 - b2) < -1.0E-7 || maxDist < penetration : (penetration = a2 - b1) > 1.0E-7 || maxDist > penetration) {
            return maxDist;
        }
        return penetration;
    }

    public List<AxisAlignedBB> func_197756_d() {
        return Lists.newArrayList((Object[])new AxisAlignedBB[]{this.func_197752_a()});
    }

    public AxisAlignedBB func_197752_a() {
        return new AxisAlignedBB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public double func_197762_b(Direction.Axis axis) {
        return axis.func_196051_a(this.minX, this.minY, this.minZ);
    }

    public double func_197758_c(Direction.Axis axis) {
        return axis.func_196051_a(this.maxX, this.maxY, this.maxZ);
    }

    protected double func_197759_b(Direction.Axis axis, int index) {
        if (index < 0 || index > 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        switch (axis) {
            case X: {
                return index == 0 ? this.minX : this.maxX;
            }
            case Y: {
                return index == 0 ? this.minY : this.maxY;
            }
            case Z: {
                return index == 0 ? this.minZ : this.maxZ;
            }
        }
        throw new IllegalArgumentException();
    }

    public DoubleList func_197757_a(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return DoubleArrayList.wrap((double[])new double[]{this.minX, this.maxX});
            }
            case Y: {
                return DoubleArrayList.wrap((double[])new double[]{this.minY, this.maxY});
            }
            case Z: {
                return DoubleArrayList.wrap((double[])new double[]{this.minZ, this.maxZ});
            }
        }
        throw new IllegalArgumentException();
    }

    protected boolean func_211542_b(double x, double y, double z) {
        return x >= this.minX && x < this.maxX && y >= this.minY && y < this.maxY && z >= this.minZ && z < this.maxZ;
    }

    public boolean func_197766_b() {
        return this.minX >= this.maxX || this.minY >= this.maxY || this.minZ >= this.maxZ;
    }

    protected int func_197749_a(Direction.Axis axis, double coord) {
        if (coord < this.func_197762_b(axis)) {
            return -1;
        }
        if (coord >= this.func_197758_c(axis)) {
            return 1;
        }
        return 0;
    }

    private static boolean lessThan(double a, double b) {
        return a + 1.0E-7 < b;
    }

    @Override
    public boolean intersects(AxisAlignedBB box, double x, double y, double z) {
        return box.field_72340_a < this.maxX + x && box.field_72336_d > this.minX + x && box.field_72338_b < this.maxY + y && box.field_72337_e > this.minY + y && box.field_72339_c < this.maxZ + z && box.field_72334_f > this.minZ + z;
    }

    public void func_197755_b(VoxelShapes.ILineConsumer boxConsumer) {
        boxConsumer.consume(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }
}

