/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.shapes;

import it.unimi.dsi.fastutil.doubles.DoubleList;
import me.jellysquid.mods.lithium.common.shapes.CuboidVoxelSet;
import me.jellysquid.mods.lithium.common.shapes.VoxelShapeAlignedCuboidOffset;
import me.jellysquid.mods.lithium.common.shapes.VoxelShapeSimpleCube;
import net.minecraft.util.AxisRotation;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.DoubleRangeList;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapePart;

public class VoxelShapeAlignedCuboid
extends VoxelShapeSimpleCube {
    static final double LARGE_EPSILON = 1.0E-6;
    protected final int xSegments;
    protected final int ySegments;
    protected final int zSegments;

    public VoxelShapeAlignedCuboid(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int xRes, int yRes, int zRes) {
        super(new CuboidVoxelSet(1 << xRes, 1 << yRes, 1 << zRes, minX, minY, minZ, maxX, maxY, maxZ), minX, minY, minZ, maxX, maxY, maxZ);
        this.xSegments = 1 << xRes;
        this.ySegments = 1 << yRes;
        this.zSegments = 1 << zRes;
    }

    public VoxelShapeAlignedCuboid(VoxelShapePart voxels, int xSegments, int ySegments, int zSegments, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        super(voxels, minX, minY, minZ, maxX, maxY, maxZ);
        this.xSegments = xSegments;
        this.ySegments = ySegments;
        this.zSegments = zSegments;
    }

    @Override
    public VoxelShape func_197751_a(double x, double y, double z) {
        return new VoxelShapeAlignedCuboidOffset(this, this.field_197768_g, x, y, z);
    }

    @Override
    public double func_212431_a(AxisRotation cycleDirection, AxisAlignedBB box, double maxDist) {
        if (Math.abs(maxDist) < 1.0E-7) {
            return 0.0;
        }
        double penetration = this.calculatePenetration(cycleDirection, box, maxDist);
        if (penetration != maxDist && this.intersects(cycleDirection, box)) {
            return penetration;
        }
        return maxDist;
    }

    private double calculatePenetration(AxisRotation dir, AxisAlignedBB box, double maxDist) {
        switch (dir) {
            case NONE: {
                return VoxelShapeAlignedCuboid.calculatePenetration(this.minX, this.maxX, this.xSegments, box.field_72340_a, box.field_72336_d, maxDist);
            }
            case FORWARD: {
                return VoxelShapeAlignedCuboid.calculatePenetration(this.minZ, this.maxZ, this.zSegments, box.field_72339_c, box.field_72334_f, maxDist);
            }
            case BACKWARD: {
                return VoxelShapeAlignedCuboid.calculatePenetration(this.minY, this.maxY, this.ySegments, box.field_72338_b, box.field_72337_e, maxDist);
            }
        }
        throw new IllegalArgumentException();
    }

    private static double calculatePenetration(double aMin, double aMax, int segmentsPerUnit, double bMin, double bMax, double maxDist) {
        if (maxDist > 0.0) {
            double gap = aMin - bMax;
            if (gap >= -1.0E-7) {
                return Math.min(gap, maxDist);
            }
            if (segmentsPerUnit == 1) {
                return maxDist;
            }
            double wallPos = (double)MathHelper.func_76143_f((double)((bMax - 1.0E-7) * (double)segmentsPerUnit)) / (double)segmentsPerUnit;
            if (wallPos < aMax - 1.0E-6) {
                return Math.min(maxDist, wallPos - bMax);
            }
            return maxDist;
        }
        double gap = aMax - bMin;
        if (gap <= 1.0E-7) {
            return Math.max(gap, maxDist);
        }
        if (segmentsPerUnit == 1) {
            return maxDist;
        }
        double wallPos = (double)MathHelper.func_76128_c((double)((bMin + 1.0E-7) * (double)segmentsPerUnit)) / (double)segmentsPerUnit;
        if (wallPos > aMin + 1.0E-6) {
            return Math.max(maxDist, wallPos - bMin);
        }
        return maxDist;
    }

    @Override
    public DoubleList func_197757_a(Direction.Axis axis) {
        return new DoubleRangeList(axis.func_196052_a(this.xSegments, this.ySegments, this.zSegments));
    }

    @Override
    protected double func_197759_b(Direction.Axis axis, int index) {
        return (double)index / (double)axis.func_196052_a(this.xSegments, this.ySegments, this.zSegments);
    }

    @Override
    protected int func_197749_a(Direction.Axis axis, double coord) {
        int i = axis.func_196052_a(this.xSegments, this.ySegments, this.zSegments);
        return MathHelper.func_76125_a((int)MathHelper.func_76128_c((double)(coord * (double)i)), (int)-1, (int)i);
    }
}

