/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.movement;

import me.jellysquid.mods.lithium.common.shapes.VoxelShapeCaster;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;

public class BlockCollisionSweeper {
    private final BlockPos.Mutable mpos = new BlockPos.Mutable();
    private final AxisAlignedBB box;
    private final VoxelShape shape;
    private final ICollisionReader view;
    private final ISelectionContext context;
    private final CubeCoordinateIterator cuboidIt;
    private VoxelShape collidedShape;

    public BlockCollisionSweeper(ICollisionReader view, Entity entity, AxisAlignedBB box) {
        this.box = box;
        this.shape = VoxelShapes.func_197881_a((AxisAlignedBB)box);
        this.context = entity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)entity);
        this.view = view;
        this.cuboidIt = BlockCollisionSweeper.createVolumeIteratorForCollision(box);
    }

    public boolean step() {
        VoxelShape collisionShape;
        this.collidedShape = null;
        CubeCoordinateIterator cuboidIt = this.cuboidIt;
        if (!cuboidIt.func_218301_a()) {
            return false;
        }
        int edgesHit = cuboidIt.func_223473_e();
        if (edgesHit == 3) {
            return true;
        }
        int x = cuboidIt.func_218304_b();
        int y = cuboidIt.func_218302_c();
        int z = cuboidIt.func_218303_d();
        IBlockReader chunk = this.view.func_225522_c_(x >> 4, z >> 4);
        if (chunk == null) {
            return true;
        }
        BlockPos.Mutable mpos = this.mpos;
        mpos.func_181079_c(x, y, z);
        BlockState state = chunk.func_180495_p((BlockPos)mpos);
        if (BlockCollisionSweeper.canInteractWithBlock(state, edgesHit) && (collisionShape = state.func_215685_b((IBlockReader)this.view, (BlockPos)mpos, this.context)) != VoxelShapes.func_197880_a()) {
            this.collidedShape = BlockCollisionSweeper.getCollidedShape(this.box, this.shape, collisionShape, x, y, z);
        }
        return true;
    }

    public VoxelShape getCollidedShape() {
        return this.collidedShape;
    }

    private static CubeCoordinateIterator createVolumeIteratorForCollision(AxisAlignedBB box) {
        int minX = MathHelper.func_76128_c((double)(box.field_72340_a - 1.0E-7)) - 1;
        int maxX = MathHelper.func_76128_c((double)(box.field_72336_d + 1.0E-7)) + 1;
        int minY = MathHelper.func_76128_c((double)(box.field_72338_b - 1.0E-7)) - 1;
        int maxY = MathHelper.func_76128_c((double)(box.field_72337_e + 1.0E-7)) + 1;
        int minZ = MathHelper.func_76128_c((double)(box.field_72339_c - 1.0E-7)) - 1;
        int maxZ = MathHelper.func_76128_c((double)(box.field_72334_f + 1.0E-7)) + 1;
        return new CubeCoordinateIterator(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static boolean canInteractWithBlock(BlockState state, int edgesHit) {
        return !(edgesHit == 1 && !state.func_215704_f() || edgesHit == 2 && state.func_177230_c() != Blocks.field_196603_bb);
    }

    private static VoxelShape getCollidedShape(AxisAlignedBB entityBox, VoxelShape entityShape, VoxelShape shape, int x, int y, int z) {
        if (shape instanceof VoxelShapeCaster) {
            if (((VoxelShapeCaster)shape).intersects(entityBox, x, y, z)) {
                return shape.func_197751_a((double)x, (double)y, (double)z);
            }
            return null;
        }
        if (VoxelShapes.func_197879_c((VoxelShape)(shape = shape.func_197751_a((double)x, (double)y, (double)z)), (VoxelShape)entityShape, (IBooleanFunction)IBooleanFunction.field_223238_i_)) {
            return shape;
        }
        return null;
    }
}

