/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.jellysquid.mods.lithium.common.entity.movement.BlockCollisionPredicate;
import me.jellysquid.mods.lithium.common.entity.movement.ChunkAwareBlockCollisionSweeper;
import me.jellysquid.mods.lithium.common.util.Producer;
import me.jellysquid.mods.lithium.common.world.WorldHelper;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IEntityReader;
import net.minecraft.world.border.WorldBorder;

public class LithiumEntityCollisions {
    public static final double EPSILON = 1.0E-7;

    public static Stream<VoxelShape> getBlockCollisions(ICollisionReader world, Entity entity, AxisAlignedBB box, BlockCollisionPredicate predicate) {
        if (LithiumEntityCollisions.isBoxEmpty(box)) {
            return Stream.empty();
        }
        final ChunkAwareBlockCollisionSweeper sweeper = new ChunkAwareBlockCollisionSweeper(world, entity, box, predicate);
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<VoxelShape>(Long.MAX_VALUE, 1280){

            @Override
            public boolean tryAdvance(Consumer<? super VoxelShape> consumer) {
                VoxelShape shape = sweeper.getNextCollidedShape();
                if (shape != null) {
                    consumer.accept((VoxelShape)shape);
                    return true;
                }
                return false;
            }
        }, false);
    }

    public static boolean doesBoxCollideWithBlocks(ICollisionReader world, Entity entity, AxisAlignedBB box, BlockCollisionPredicate predicate) {
        if (LithiumEntityCollisions.isBoxEmpty(box)) {
            return false;
        }
        ChunkAwareBlockCollisionSweeper sweeper = new ChunkAwareBlockCollisionSweeper(world, entity, box, predicate);
        VoxelShape shape = sweeper.getNextCollidedShape();
        return shape != null;
    }

    public static boolean doesBoxCollideWithEntities(IEntityReader view, Entity entity, AxisAlignedBB box, Predicate<Entity> predicate) {
        if (LithiumEntityCollisions.isBoxEmpty(box)) {
            return false;
        }
        return LithiumEntityCollisions.getEntityCollisionProducer(view, entity, box.func_186662_g(1.0E-7), predicate).computeNext(null);
    }

    public static Stream<VoxelShape> getEntityCollisions(IEntityReader view, Entity entity, AxisAlignedBB box, Predicate<Entity> predicate) {
        if (LithiumEntityCollisions.isBoxEmpty(box)) {
            return Stream.empty();
        }
        return Producer.asStream(LithiumEntityCollisions.getEntityCollisionProducer(view, entity, box.func_186662_g(1.0E-7), predicate));
    }

    public static Producer<VoxelShape> getEntityCollisionProducer(final IEntityReader view, final Entity entity, final AxisAlignedBB box, final Predicate<Entity> predicate) {
        return new Producer<VoxelShape>(){
            private Iterator<Entity> it;

            @Override
            public boolean computeNext(Consumer<? super VoxelShape> consumer) {
                if (this.it == null) {
                    this.it = WorldHelper.getEntitiesWithCollisionBoxForEntity(view, box, entity).iterator();
                }
                while (this.it.hasNext()) {
                    Entity otherEntity = this.it.next();
                    if (!predicate.test(otherEntity) || (entity != null ? !entity.func_241849_j(otherEntity) : !otherEntity.func_70067_L())) continue;
                    if (consumer != null) {
                        consumer.accept((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)otherEntity.func_174813_aQ()));
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static boolean isWithinWorldBorder(WorldBorder border, AxisAlignedBB box) {
        double wboxMinX = Math.floor(border.func_177726_b());
        double wboxMinZ = Math.floor(border.func_177736_c());
        double wboxMaxX = Math.ceil(border.func_177728_d());
        double wboxMaxZ = Math.ceil(border.func_177733_e());
        return box.field_72340_a >= wboxMinX && box.field_72340_a < wboxMaxX && box.field_72339_c >= wboxMinZ && box.field_72339_c < wboxMaxZ && box.field_72336_d >= wboxMinX && box.field_72336_d < wboxMaxX && box.field_72334_f >= wboxMinZ && box.field_72334_f < wboxMaxZ;
    }

    public static boolean canEntityCollideWithWorldBorder(ICollisionReader world, Entity entity) {
        WorldBorder border = world.func_175723_af();
        boolean isInsideBorder = LithiumEntityCollisions.isWithinWorldBorder(border, entity.func_174813_aQ().func_186664_h(1.0E-7));
        boolean isCrossingBorder = LithiumEntityCollisions.isWithinWorldBorder(border, entity.func_174813_aQ().func_186662_g(1.0E-7));
        return !isInsideBorder && isCrossingBorder;
    }

    private static boolean isBoxEmpty(AxisAlignedBB box) {
        return box.func_72320_b() <= 1.0E-7;
    }
}

