/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.ai.pathing;

import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import me.jellysquid.mods.lithium.common.ai.pathing.BlockStatePathingCache;
import net.minecraft.block.BlockState;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.world.chunk.ChunkSection;

public class PathNodeCache {
    private static final Reference2BooleanMap<ChunkSection> chunkNeighborDangerCache = new Reference2BooleanOpenHashMap();
    private static boolean dangerCacheEnabled = false;
    private static ChunkSection prevQueriedNeighborSectionKey;
    private static boolean prevQueriedNeighborSectionResult;

    public static void enableChunkCache() {
        dangerCacheEnabled = true;
    }

    public static void disableChunkCache() {
        dangerCacheEnabled = false;
        chunkNeighborDangerCache.clear();
        prevQueriedNeighborSectionKey = null;
        prevQueriedNeighborSectionResult = false;
    }

    private static boolean isChunkSectionDangerousNeighbor(ChunkSection section) {
        return section.func_186049_g().func_235963_a_(state -> PathNodeCache.getNeighborPathNodeType(state) != PathNodeType.OPEN);
    }

    public static PathNodeType getPathNodeType(BlockState state) {
        return ((BlockStatePathingCache)state).getPathNodeType();
    }

    public static PathNodeType getNeighborPathNodeType(BlockState state) {
        return ((BlockStatePathingCache)state).getNeighborPathNodeType();
    }

    public static boolean isSectionSafeAsNeighbor(ChunkSection section) {
        if (ChunkSection.func_222628_a((ChunkSection)section)) {
            return true;
        }
        if (!dangerCacheEnabled) {
            return false;
        }
        if (prevQueriedNeighborSectionKey != section) {
            prevQueriedNeighborSectionKey = section;
            prevQueriedNeighborSectionResult = !chunkNeighborDangerCache.computeBooleanIfAbsent((Object)section, PathNodeCache::isChunkSectionDangerousNeighbor);
        }
        return prevQueriedNeighborSectionResult;
    }
}

