/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blocks;

import com.ldtteam.structurize.api.blocks.IBlockList;
import com.ldtteam.structurize.api.generation.ModBlockStateProvider;
import com.ldtteam.structurize.api.generation.ModBlockTagsProvider;
import com.ldtteam.structurize.api.generation.ModItemModelProvider;
import com.ldtteam.structurize.api.generation.ModItemTagsProvider;
import com.ldtteam.structurize.api.generation.ModRecipeProvider;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.decorative.BlockFloatingCarpet;
import com.ldtteam.structurize.items.ModItemGroups;
import com.ldtteam.structurize.items.ModItems;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.RegistryObject;

public class FloatingCarpetList
implements IBlockList<BlockFloatingCarpet> {
    public static final ITag.INamedTag<Block> BLOCK_TAG = BlockTags.func_199894_a((String)"structurize:floating_carpets");
    public static final ITag.INamedTag<Item> ITEM_TAG = ItemTags.func_199901_a((String)"structurize:floating_carpets");
    private final List<RegistryObject<BlockFloatingCarpet>> blocks = new LinkedList<RegistryObject<BlockFloatingCarpet>>();

    public FloatingCarpetList() {
        for (DyeColor color : DyeColor.values()) {
            this.blocks.add(ModBlocks.register(color.func_176762_d() + "_floating_carpet", () -> new BlockFloatingCarpet(color), ModItemGroups.STRUCTURIZE));
        }
    }

    @Override
    public List<RegistryObject<BlockFloatingCarpet>> getRegisteredBlocks() {
        return this.blocks;
    }

    @Override
    public void generateBlockStates(ModBlockStateProvider states) {
        this.getBlocks().forEach(block -> states.getVariantBuilder((Block)block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)new ModelFile.UncheckedModelFile("minecraft:block/" + block.getColor().func_176762_d() + "_carpet"))}));
    }

    @Override
    public void generateItemModels(ModItemModelProvider models) {
        this.getBlocks().forEach(block -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)models.withExistingParent(block.getRegistryName().func_110623_a(), "minecraft:" + block.getColor().func_176762_d() + "_carpet");
        });
    }

    @Override
    public void generateRecipes(ModRecipeProvider provider) {
        this.getBlocks().forEach(block -> {
            provider.add(consumer -> new ShapedRecipeBuilder((IItemProvider)block, 1).func_200472_a("B").func_200472_a("C").func_200472_a("S").func_200462_a(Character.valueOf('B'), (IItemProvider)ModItems.buildTool.get()).func_200462_a(Character.valueOf('C'), (IItemProvider)Registry.field_212618_g.func_82594_a(new ResourceLocation(block.getColor().func_176762_d() + "_carpet"))).func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.STRING).func_200465_a("has_" + block.getRegistryName().func_110623_a(), ModRecipeProvider.getDefaultCriterion((IItemProvider)block)).func_200464_a(consumer));
            provider.add(consumer -> {
                ShapelessRecipeBuilder builder = new ShapelessRecipeBuilder((IItemProvider)block, 8);
                for (int i = 0; i < 8; ++i) {
                    builder.func_203221_a(ITEM_TAG);
                }
                builder.func_200487_b((IItemProvider)DyeItem.func_195961_a((DyeColor)block.getColor())).func_200483_a("can_dye_" + block.getRegistryName().func_110623_a(), ModRecipeProvider.getDefaultCriterion((IItemProvider)block)).func_200485_a(consumer, new ResourceLocation("structurize", block.getRegistryName().func_110623_a() + "_dye"));
            });
        });
    }

    @Override
    public void generateTags(ModBlockTagsProvider blocks, ModItemTagsProvider items) {
        this.getBlocks().forEach(arg_0 -> blocks.buildTag(BLOCK_TAG).func_240532_a_(arg_0));
        items.func_240521_a_(BLOCK_TAG, ITEM_TAG);
    }
}

