/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.api.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStackUtils {
    public static final ItemStack EMPTY = ItemStack.field_190927_a;

    private ItemStackUtils() {
    }

    public static List<ItemStack> getItemStacksOfTileEntity(CompoundNBT compound, BlockState state) {
        if (state.func_177230_c() instanceof ContainerBlock && compound.func_74764_b("Items")) {
            NonNullList items = NonNullList.func_191196_a();
            ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)items);
            return items;
        }
        TileEntity tileEntity = TileEntity.func_235657_b_((BlockState)state, (CompoundNBT)compound);
        if (tileEntity == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (IItemHandler handler : ItemStackUtils.getItemHandlersFromProvider((ICapabilityProvider)tileEntity)) {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
                items.add(stack);
            }
        }
        return items;
    }

    @NotNull
    public static Set<IItemHandler> getItemHandlersFromProvider(@NotNull ICapabilityProvider provider) {
        HashSet<IItemHandler> handlerSet = new HashSet<IItemHandler>();
        for (Direction side : Direction.values()) {
            provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).ifPresent(handlerSet::add);
        }
        provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(handlerSet::add);
        return handlerSet;
    }

    @NotNull
    public static Boolean isEmpty(@Nullable ItemStack stack) {
        return stack == null || stack == EMPTY || stack.func_190916_E() <= 0;
    }

    public static int getSize(ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return 0;
        }
        return stack.func_190916_E();
    }

    public static List<ItemStack> getListOfStackForEntity(Entity entity, BlockPos pos) {
        if (entity != null) {
            ArrayList<ItemStack> request = new ArrayList<ItemStack>();
            if (entity instanceof ItemFrameEntity) {
                ItemStack stack2 = ((ItemFrameEntity)entity).func_82335_i();
                if (!ItemStackUtils.isEmpty(stack2).booleanValue()) {
                    stack2.func_190920_e(1);
                    request.add(stack2);
                }
                request.add(new ItemStack((IItemProvider)Items.field_151160_bD, 1));
            } else if (entity instanceof ArmorStandEntity) {
                request.add(entity.getPickedResult(new RayTraceResult(Vector3d.func_237491_b_((Vector3i)pos)){

                    @NotNull
                    public RayTraceResult.Type func_216346_c() {
                        return RayTraceResult.Type.ENTITY;
                    }
                }));
                entity.func_184193_aE().forEach(request::add);
                entity.func_184214_aD().forEach(request::add);
            }
            return request.stream().filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @NotNull
    public static Boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, true, true);
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, matchDamage, matchNBT, false);
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT, boolean min) {
        if (ItemStackUtils.isEmpty(itemStack1).booleanValue() && ItemStackUtils.isEmpty(itemStack2).booleanValue()) {
            return true;
        }
        if (ItemStackUtils.isEmpty(itemStack1) != ItemStackUtils.isEmpty(itemStack2)) {
            return false;
        }
        if (!(itemStack1.func_77973_b() != itemStack2.func_77973_b() || matchDamage && itemStack1.func_77952_i() != itemStack2.func_77952_i())) {
            if (!matchNBT) {
                return true;
            }
            if (min && itemStack1.func_190916_E() > itemStack2.func_190916_E()) {
                return false;
            }
            if (itemStack1.func_77942_o() && itemStack2.func_77942_o()) {
                CompoundNBT nbt1 = itemStack1.func_77978_p();
                CompoundNBT nbt2 = itemStack2.func_77978_p();
                for (String key : nbt1.func_150296_c()) {
                    if (!matchDamage && key.equals("Damage") || nbt2.func_74764_b(key) && nbt1.func_74781_a(key).equals(nbt2.func_74781_a(key))) continue;
                    return false;
                }
                return nbt1.func_150296_c().size() == nbt2.func_150296_c().size();
            }
            return !(itemStack1.func_77942_o() && !itemStack1.func_77978_p().isEmpty() || itemStack2.func_77942_o() && !itemStack2.func_77978_p().isEmpty());
        }
        return false;
    }
}

