/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.fluid;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class MultiFluidStorage
extends FluidTank {
    int maxFluids = 1;
    List<FluidStack> fluids;

    public MultiFluidStorage(int capacity, int maxFluids) {
        super(capacity);
        this.maxFluids = maxFluids;
        this.fluids = new ArrayList<FluidStack>();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    public FluidTank readFromNBT(CompoundNBT nbt) {
        if (!nbt.func_74764_b("Fluids")) {
            this.fluids = new ArrayList<FluidStack>();
        } else {
            this.fluids = new ArrayList<FluidStack>();
            ListNBT nbt_fluids = nbt.func_150295_c("Fluids", 10);
            for (int i = 0; i < nbt_fluids.size(); ++i) {
                CompoundNBT nbt_fluid = nbt_fluids.func_150305_b(i);
                this.fluids.add(FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt_fluid));
            }
        }
        return this;
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        if (this.fluids.size() > 0) {
            ListNBT nbt_fluids = new ListNBT();
            for (FluidStack fluid : this.fluids) {
                CompoundNBT nbt_fluid = new CompoundNBT();
                fluid.writeToNBT(nbt_fluid);
                nbt_fluids.add((Object)nbt_fluid);
            }
            nbt.func_218657_a("Fluids", (INBT)nbt_fluids);
        }
        return nbt;
    }

    @Nullable
    public FluidStack getFluid() {
        if (this.fluids.size() == 0) {
            return FluidStack.EMPTY;
        }
        return this.fluids.get(0);
    }

    public int getFluidAmount() {
        int fluidamount = 0;
        for (FluidStack fluid : this.fluids) {
            fluidamount += fluid.getAmount();
        }
        return fluidamount;
    }

    public ItemStack getFluidBucket(FluidStack targetFluid) {
        for (FluidStack fluid : this.fluids) {
            if (!fluid.getFluid().equals(targetFluid.getFluid()) || fluid.getAmount() < 1000) continue;
            ItemStack bucket = FluidUtil.getFilledBucket((FluidStack)targetFluid);
            if (!bucket.func_190926_b()) {
                fluid.setAmount(fluid.getAmount() - 1000);
                if (fluid.getAmount() <= 0) {
                    this.fluids.remove(fluid);
                }
                this.onContentsChanged();
                return bucket;
            }
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    public List<FluidStack> getFluids() {
        ArrayList<FluidStack> copyFluids = new ArrayList<FluidStack>();
        for (FluidStack fluid : this.fluids) {
            copyFluids.add(new FluidStack(fluid.getFluid(), fluid.getAmount()));
        }
        return copyFluids;
    }

    public int fillInternal(FluidStack resource, boolean doFill) {
        if (resource == null || resource.getAmount() <= 0) {
            return 0;
        }
        if (!doFill) {
            if (this.fluid == null) {
                return Math.min(this.capacity, resource.getAmount());
            }
            if (!this.fluid.isFluidEqual(resource)) {
                if (this.maxFluids > this.fluids.size()) {
                    return Math.min(this.capacity - this.getFluidAmount(), resource.getAmount());
                }
                return 0;
            }
            return Math.min(this.capacity - this.getFluidAmount(), resource.getAmount());
        }
        for (FluidStack fluid : this.fluids) {
            if (fluid.getFluid() != resource.getFluid()) continue;
            int filled = this.capacity - this.getFluidAmount();
            if (resource.getAmount() < filled) {
                filled = resource.getAmount();
            }
            fluid.setAmount(fluid.getAmount() + filled);
            this.onContentsChanged();
            return filled;
        }
        if (this.maxFluids > this.fluids.size()) {
            FluidStack fluid = new FluidStack(resource, Math.min(this.capacity - this.getFluidAmount(), resource.getAmount()));
            this.onContentsChanged();
            this.fluids.add(fluid);
            return fluid.getAmount();
        }
        return 0;
    }

    @Nullable
    public FluidStack drainInternal(FluidStack resource, boolean doDrain) {
        if (resource == null || !this.canDrainFluidType(resource)) {
            return FluidStack.EMPTY;
        }
        return this.drainInternal(resource, resource.getAmount(), doDrain);
    }

    @Nullable
    public FluidStack drainInternal(FluidStack resource, int maxDrain, boolean doDrain) {
        if (resource == null || maxDrain <= 0 || !this.canDrainFluidType(resource)) {
            return FluidStack.EMPTY;
        }
        FluidStack fluid = null;
        for (FluidStack _fluid : this.fluids) {
            if (_fluid.getFluid() != resource.getFluid()) continue;
            fluid = _fluid;
        }
        if (fluid == null) {
            return FluidStack.EMPTY;
        }
        int drained = maxDrain;
        if (fluid.getAmount() < drained) {
            drained = fluid.getAmount();
        }
        FluidStack stack = new FluidStack(fluid, drained);
        if (doDrain) {
            fluid.setAmount(fluid.getAmount() - drained);
            if (fluid.getAmount() <= 0) {
                this.fluids.remove(fluid);
            }
            this.onContentsChanged();
        }
        return stack;
    }

    private void removeEmpty() {
        for (FluidStack fluid : this.fluids) {
            if (fluid != null && fluid.getAmount() != 0) continue;
            this.fluids.remove(fluid);
        }
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.canDrainFluidType(resource)) {
            return FluidStack.EMPTY;
        }
        FluidStack dr = this.drainInternal(resource, action.execute());
        return dr;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack resource = this.getFluid();
        if (!this.canDrainFluidType(resource)) {
            return FluidStack.EMPTY;
        }
        FluidStack dr = this.drainInternal(resource, maxDrain, action.execute());
        return dr;
    }

    public boolean canDrainFluidType(@Nullable FluidStack resource) {
        if (resource == null) {
            return false;
        }
        for (FluidStack fluid : this.fluids) {
            if (fluid.getFluid() != resource.getFluid()) continue;
            return true;
        }
        return false;
    }

    protected void onContentsChanged() {
        this.removeEmpty();
    }
}

