/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.collection;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import quphoria.compactvoidminers.CompactVoidMiners;
import quphoria.compactvoidminers.cache.TagCache;
import quphoria.compactvoidminers.config.Config;
import quphoria.compactvoidminers.init.ModItems;

public class TagCollection {
    public static Pair<Item, ResourceLocation> collect(Random rand) {
        if (TagCache.getTags().size() == 0) {
            return null;
        }
        ResourceLocation itemTag = TagCache.getTags().get(rand.nextInt(TagCache.getTags().size()));
        if (TagCache.getItems(itemTag).size() == 0) {
            return null;
        }
        ResourceLocation itemName = TagCache.getItems(itemTag).get(rand.nextInt(TagCache.getItems(itemTag).size()));
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemName);
        if (CompactVoidMiners.logCollection) {
            CompactVoidMiners.LOGGER.info("TAGNAME>>" + itemTag.toString() + " ITEM>>" + itemName.toString());
        }
        return new Pair((Object)item, (Object)itemTag);
    }

    public static boolean checkTagBlacklist(ResourceLocation tag) {
        for (String key : (List)Config.voidminer.tagPartialBlacklist.get()) {
            if (!tag.func_110623_a().toLowerCase().contains(key.toLowerCase())) continue;
            return true;
        }
        for (String key : (List)Config.voidminer.tagExactBlacklist.get()) {
            if (!tag.func_110623_a().equals(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkItemBlacklist(ResourceLocation item) {
        for (String key : (List)Config.voidminer.itemBlacklist.get()) {
            if (!item.toString().equals(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkWildcardItemBlacklist(ResourceLocation item) {
        for (String wildcardPattern : Config.voidminer.parsedItemWildcardBlacklist) {
            if (!item.toString().matches(wildcardPattern)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnabledTagType(ResourceLocation tag) {
        if (TagCollection.isMiscOredictionary(tag)) {
            for (String enabled_prefix : (List)Config.voidminer.enabledTagPrefixes.get()) {
                if (!enabled_prefix.equals("misc")) continue;
                return true;
            }
        } else {
            for (String enabled_prefix : (List)Config.voidminer.enabledTagPrefixes.get()) {
                for (String prefix : ModItems.filter_prefixes) {
                    if (!prefix.equals(enabled_prefix) || !tag.func_110623_a().startsWith(prefix)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isMiscOredictionary(ResourceLocation tag) {
        for (String prefix : ModItems.filter_prefixes) {
            if (prefix.equals("misc") || !tag.func_110623_a().startsWith(prefix)) continue;
            return false;
        }
        return true;
    }
}

