/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.chunkloader;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.ForgeChunkManager;
import quphoria.compactvoidminers.blocks.TileEntityMachine;
import quphoria.compactvoidminers.config.Config;

public class ChunkLoaderManager
implements ForgeChunkManager.LoadingValidationCallback {
    List<BlockPos> loaded_chunks = new ArrayList<BlockPos>();

    public boolean AddBlockTicket(ServerWorld world, BlockPos pos) {
        int z;
        int x;
        ChunkPos chunk = new ChunkPos(pos);
        boolean success = true;
        int radius = (Integer)Config.general.chunkloaderRadius.get();
        for (x = chunk.field_77276_a - radius; x <= chunk.field_77276_a + radius; ++x) {
            for (z = chunk.field_77275_b - radius; z <= chunk.field_77275_b + radius; ++z) {
                success &= ForgeChunkManager.forceChunk((ServerWorld)world, (String)"compactvoidminers", (BlockPos)pos, (int)x, (int)z, (boolean)true, (boolean)true);
            }
        }
        if (!success) {
            for (x = chunk.field_77276_a - radius; x <= chunk.field_77276_a + radius; ++x) {
                for (z = chunk.field_77275_b - radius; z <= chunk.field_77275_b + radius; ++z) {
                    ForgeChunkManager.forceChunk((ServerWorld)world, (String)"compactvoidminers", (BlockPos)pos, (int)x, (int)z, (boolean)false, (boolean)true);
                }
            }
        }
        return success;
    }

    public boolean RemoveBlockTicket(ServerWorld world, BlockPos pos) {
        ChunkPos chunk = new ChunkPos(pos);
        boolean success = true;
        int radius = (Integer)Config.general.chunkloaderRadius.get();
        for (int x = chunk.field_77276_a - radius; x <= chunk.field_77276_a + radius; ++x) {
            for (int z = chunk.field_77275_b - radius; z <= chunk.field_77275_b + radius; ++z) {
                success &= ForgeChunkManager.forceChunk((ServerWorld)world, (String)"compactvoidminers", (BlockPos)pos, (int)x, (int)z, (boolean)false, (boolean)true);
            }
        }
        return success;
    }

    public void AddChunkloader(World world, BlockPos pos, String lastPlayer) {
        if (!world.field_72995_K && world instanceof ServerWorld && !this.loaded_chunks.contains(pos) && this.AddBlockTicket((ServerWorld)world, pos)) {
            this.loaded_chunks.add(pos);
        }
    }

    public void RemoveChunkloader(World world, BlockPos pos) {
        if (!world.field_72995_K && world instanceof ServerWorld && this.loaded_chunks.contains(pos) && this.RemoveBlockTicket((ServerWorld)world, pos)) {
            this.loaded_chunks.remove(pos);
        }
    }

    public void validateTickets(ServerWorld world, ForgeChunkManager.TicketHelper ticketHelper) {
        for (BlockPos pos : ticketHelper.getBlockTickets().keySet()) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityMachine) {
                if (((TileEntityMachine)tile).hasChunkloaderUpgrade()) {
                    if (this.loaded_chunks.contains(pos)) continue;
                    this.loaded_chunks.add(pos);
                    continue;
                }
                ticketHelper.removeAllTickets(pos);
                continue;
            }
            ticketHelper.removeAllTickets(pos);
        }
    }
}

